/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import java.util.Arrays;
import java.util.Comparator;

public final class EngineIoServerOptions {
    public static final EngineIoServerOptions DEFAULT = new EngineIoServerOptions();
    public static final String[] ALLOWED_CORS_ORIGIN_ALL = null;
    public static final String[] ALLOWED_CORS_ORIGIN_NONE = new String[0];
    private boolean mIsLocked = false;
    private long mPingInterval;
    private long mPingTimeout;
    private String[] mAllowedCorsOrigins;

    private EngineIoServerOptions() {
    }

    public static EngineIoServerOptions newFromDefault() {
        return new EngineIoServerOptions().setPingInterval(DEFAULT.getPingInterval()).setPingTimeout(DEFAULT.getPingTimeout()).setAllowedCorsOrigins(DEFAULT.getAllowedCorsOrigins());
    }

    public long getPingInterval() {
        return this.mPingInterval;
    }

    public EngineIoServerOptions setPingInterval(long pingInterval) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Ping interval cannot be set. Instance is locked.");
        }
        this.mPingInterval = pingInterval;
        return this;
    }

    public long getPingTimeout() {
        return this.mPingTimeout;
    }

    public EngineIoServerOptions setPingTimeout(long pingTimeout) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Ping timeout cannot be set. Instance is locked.");
        }
        this.mPingTimeout = pingTimeout;
        return this;
    }

    public String[] getAllowedCorsOrigins() {
        return this.mAllowedCorsOrigins;
    }

    public EngineIoServerOptions setAllowedCorsOrigins(String[] allowedCorsOrigins) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Allowed cors origins cannot be set. Instance is locked.");
        }
        this.mAllowedCorsOrigins = null;
        if (allowedCorsOrigins != null) {
            this.mAllowedCorsOrigins = new String[allowedCorsOrigins.length];
            System.arraycopy(allowedCorsOrigins, 0, this.mAllowedCorsOrigins, 0, allowedCorsOrigins.length);
            Arrays.sort(this.mAllowedCorsOrigins, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        return this;
    }

    public void lock() {
        this.mIsLocked = true;
    }

    static {
        DEFAULT.setPingTimeout(5000L);
        DEFAULT.setPingInterval(25000L);
        DEFAULT.setAllowedCorsOrigins(ALLOWED_CORS_ORIGIN_ALL);
        DEFAULT.lock();
    }
}

