/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.processor;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import trip.spi.Producer;
import trip.spi.ProducerFactory;
import trip.spi.Singleton;
import trip.spi.Stateless;
import trip.spi.helpers.ServiceLoader;
import trip.spi.processor.GenerableClass;
import trip.spi.processor.ProducerImplementation;
import trip.spi.processor.SingletonImplementation;
import trip.spi.processor.stateless.StatelessClass;
import trip.spi.processor.stateless.StatelessClassGenerator;

@SupportedAnnotationTypes(value={"trip.spi.*"})
public class SPIProcessor
extends AbstractProcessor {
    static final String EOL = "\n";
    static final String SERVICES = "META-INF/services/";
    static final String PROVIDER_FILE = "META-INF/services/" + ProducerFactory.class.getCanonicalName();
    final DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
    final Mustache factoryProviderClazzTemplate = this.mustacheFactory.compile("META-INF/provided-class.mustache");
    final Map<String, Set<String>> singletons = new HashMap<String, Set<String>>();
    final StatelessClassGenerator statelessClassGenerator = new StatelessClassGenerator();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!roundEnv.processingOver()) {
                this.process(roundEnv);
            } else {
                this.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void process(RoundEnvironment roundEnv) throws IOException {
        this.processSingletons(roundEnv, Singleton.class);
        this.processStateless(roundEnv, Stateless.class);
        this.processProducers(roundEnv, Producer.class);
    }

    public void processStateless(RoundEnvironment roundEnv, Class<? extends Annotation> ann) throws IOException {
        if (ann != null) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(ann);
            for (Element element : annotatedElements) {
                if (element.getKind() != ElementKind.CLASS) continue;
                this.memorizeAServiceImplementation(StatelessClass.from((TypeElement)element));
            }
        }
    }

    void memorizeAServiceImplementation(StatelessClass clazz) throws IOException {
        this.createAStatelessClassFrom(clazz);
        String interfaceClass = clazz.getTypeCanonicalName();
        String implementationClass = clazz.getGeneratedClassCanonicalName();
        this.memorizeAServiceImplementation(interfaceClass, implementationClass);
    }

    void createAStatelessClassFrom(StatelessClass clazz) throws IOException {
        String name = clazz.getGeneratedClassCanonicalName();
        if (!this.classExists(name)) {
            this.info("Generating " + name);
            JavaFileObject sourceFile = this.filer().createSourceFile(name, new Element[0]);
            Writer writer = sourceFile.openWriter();
            this.statelessClassGenerator.write(clazz, writer);
            writer.close();
        }
    }

    public void processSingletons(RoundEnvironment roundEnv, Class<? extends Annotation> ann) throws IOException {
        if (ann != null) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(ann);
            for (Element element : annotatedElements) {
                if (element.getKind() != ElementKind.CLASS) continue;
                this.memorizeAllImplementations((TypeElement)element);
            }
        }
    }

    private void memorizeAllImplementations(TypeElement type) throws IOException {
        String implementationClass = type.asType().toString();
        TypeMirror superinterfaceOrClass = SingletonImplementation.getProvidedServiceClass(type);
        if (superinterfaceOrClass != null) {
            this.memorizeAServiceImplementation(new SingletonImplementation(superinterfaceOrClass.toString(), implementationClass));
        } else {
            for (TypeMirror typeMirror : type.getInterfaces()) {
                this.memorizeAServiceImplementation(new SingletonImplementation(typeMirror.toString(), implementationClass));
            }
            this.memorizeAServiceImplementation(new SingletonImplementation(implementationClass, implementationClass));
        }
    }

    void memorizeAServiceImplementation(SingletonImplementation from) {
        String interfaceClass = from.interfaceClass();
        String implementationClass = from.implementationClass();
        this.memorizeAServiceImplementation(interfaceClass, implementationClass);
    }

    void memorizeAServiceImplementation(String interfaceClass, String implementationClass) {
        Set<String> list = this.singletons.get(interfaceClass);
        if (list == null) {
            list = this.readAListWithAllCreatedClassesImplementing(interfaceClass);
            this.singletons.put(interfaceClass, list);
        }
        list.add(implementationClass);
    }

    private HashSet<String> readAListWithAllCreatedClassesImplementing(String interfaceClass) {
        LinkedHashSet<String> foundSingletons = new LinkedHashSet<String>();
        for (Class implementationClass : ServiceLoader.loadImplementationsFor((String)interfaceClass)) {
            foundSingletons.add(implementationClass.getCanonicalName());
        }
        return foundSingletons;
    }

    public void processProducers(RoundEnvironment roundEnv, Class<? extends Annotation> ann) throws IOException {
        if (ann != null) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(ann);
            for (Element element : annotatedElements) {
                if (element.getKind() != ElementKind.METHOD) continue;
                this.createAProducerFrom(ProducerImplementation.from((ExecutableElement)element));
            }
        }
    }

    void createAProducerFrom(GenerableClass clazz) throws IOException {
        String name = clazz.getGeneratedClassCanonicalName();
        if (!this.classExists(name)) {
            this.info("Generating " + name);
            JavaFileObject sourceFile = this.filer().createSourceFile(name, new Element[0]);
            Writer writer = sourceFile.openWriter();
            this.factoryProviderClazzTemplate.execute(writer, (Object)clazz);
            writer.close();
        }
    }

    boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Exception cause) {
            return false;
        }
    }

    String createClassCanonicalName(ProducerImplementation clazz) {
        return String.format("%s.%sAutoGeneratedProvider%s", clazz.packageName(), clazz.typeName(), clazz.providerName());
    }

    void createSingletonMetaInf() throws IOException {
        for (String interfaceClass : this.singletons.keySet()) {
            Writer resource = this.createResource(SERVICES + interfaceClass);
            System.out.println("[INFO] Exposing implementations of " + interfaceClass);
            for (String implementation : this.singletons.get(interfaceClass)) {
                System.out.println("[INFO]  > " + implementation);
                this.log("Exposing " + implementation + " as " + interfaceClass);
                resource.write(implementation + EOL);
            }
            resource.close();
        }
    }

    Writer createResource(String resourcePath) throws IOException {
        FileObject resource = this.filer().getResource(StandardLocation.CLASS_OUTPUT, "", resourcePath);
        URI uri = resource.toUri();
        this.createNeededDirectoriesTo(uri);
        File file = this.createFile(uri);
        return new FileWriter(file);
    }

    void createNeededDirectoriesTo(URI uri) {
        File dir = null;
        dir = uri.isAbsolute() ? new File(uri).getParentFile() : new File(uri.toString()).getParentFile();
        dir.mkdirs();
    }

    File createFile(URI uri) throws IOException {
        File file = new File(uri);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    Filer filer() {
        return this.processingEnv.getFiler();
    }

    private void info(String msg) {
        System.out.println("[INFO] " + msg);
        this.log(msg);
    }

    private void log(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    public void flush() throws IOException {
        if (!this.singletons.isEmpty()) {
            this.createSingletonMetaInf();
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.values()[SourceVersion.values().length - 1];
    }
}

