/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.processor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import trip.spi.Qualifier;
import trip.spi.Singleton;
import trip.spi.Stateless;
import trip.spi.processor.NameTransformations;

public class SingletonImplementation {
    public static final List<Class<? extends Annotation>> QUALIFIERS = Arrays.asList(Qualifier.class);
    final String interfaceClass;
    final String implementationClass;

    public SingletonImplementation(String interfaceClass, String implementationClass) {
        this.interfaceClass = NameTransformations.stripGenericsFrom(interfaceClass);
        this.implementationClass = NameTransformations.stripGenericsFrom(implementationClass);
    }

    public String implementationClass() {
        return this.implementationClass;
    }

    public String interfaceClass() {
        return this.interfaceClass;
    }

    public static String getProvidedServiceClassAsString(TypeElement type) {
        return SingletonImplementation.getProvidedServiceClassAsString(type, type.asType().toString());
    }

    public static String getProvidedServiceClassAsStringOrNull(TypeElement type) {
        String string = SingletonImplementation.getProvidedServiceClassAsString(type, null);
        if (string == null && (SingletonImplementation.isAnnotatedForSingleton(type) || SingletonImplementation.isAnnotatedForStateless(type))) {
            string = type.asType().toString();
        }
        return string;
    }

    private static String getProvidedServiceClassAsString(TypeElement type, String defaultValue) {
        TypeMirror typeMirror = SingletonImplementation.getProvidedServiceClass(type);
        if (typeMirror != null) {
            return typeMirror.toString();
        }
        return defaultValue;
    }

    public static TypeMirror getProvidedServiceClass(TypeElement type) {
        TypeMirror foundType = null;
        if (SingletonImplementation.isAnnotatedForStateless(type)) {
            foundType = SingletonImplementation.getProvidedServiceClassForStateless(type);
        }
        if (foundType == null && SingletonImplementation.isAnnotatedForSingleton(type)) {
            foundType = SingletonImplementation.getProvidedServiceClassForSingleton(type);
        }
        return foundType;
    }

    private static boolean isAnnotatedForStateless(TypeElement type) {
        return type.getAnnotation(Stateless.class) != null;
    }

    private static boolean isAnnotatedForSingleton(TypeElement type) {
        return type.getAnnotation(Singleton.class) != null;
    }

    private static TypeMirror getProvidedServiceClassForStateless(TypeElement type) {
        TypeMirror statelessService = SingletonImplementation.getProvidedStatelessAsTypeMirror(type);
        if (SingletonImplementation.isStatelessAnnotationClassBlank(statelessService)) {
            return null;
        }
        return statelessService;
    }

    private static TypeMirror getProvidedStatelessAsTypeMirror(TypeElement type) {
        try {
            Stateless singleton = type.getAnnotation(Stateless.class);
            if (singleton != null) {
                singleton.exposedAs();
            }
            return null;
        }
        catch (MirroredTypeException cause) {
            return cause.getTypeMirror();
        }
    }

    private static boolean isStatelessAnnotationClassBlank(TypeMirror providedClass) {
        return providedClass.toString().equals(Stateless.class.getCanonicalName());
    }

    private static TypeMirror getProvidedServiceClassForSingleton(TypeElement type) {
        TypeMirror providedClass = SingletonImplementation.getProvidedSingletonAsTypeMirror(type);
        if (SingletonImplementation.isSingletonAnnotationBlank(providedClass)) {
            return null;
        }
        return providedClass;
    }

    private static TypeMirror getProvidedSingletonAsTypeMirror(TypeElement type) {
        try {
            Singleton singleton = type.getAnnotation(Singleton.class);
            if (singleton != null) {
                singleton.exposedAs();
            }
            return null;
        }
        catch (MirroredTypeException cause) {
            return cause.getTypeMirror();
        }
    }

    private static boolean isSingletonAnnotationBlank(TypeMirror providedClass) {
        return providedClass.toString().equals(Singleton.class.getCanonicalName());
    }

    public static List<String> getQualifierAnnotation(Element type) {
        ArrayList<String> qualifierAnn = new ArrayList<String>();
        for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            for (Class<? extends Annotation> annClass : QUALIFIERS) {
                if (!SingletonImplementation.isAnnotationPresent(annotationMirror.getAnnotationType().asElement(), annClass.getCanonicalName())) continue;
                qualifierAnn.add(annotationMirror.getAnnotationType().toString());
            }
        }
        return qualifierAnn;
    }

    static boolean isAnnotationPresent(Element element, String canonicalName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)annotationType.asElement();
            if (!annotationElement.getQualifiedName().contentEquals(canonicalName)) continue;
            return true;
        }
        return false;
    }
}

