/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.processor;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import trip.spi.ProviderContext;
import trip.spi.processor.GenerableClass;
import trip.spi.processor.NameTransformations;
import trip.spi.processor.SingletonImplementation;

public class ProducerImplementation
implements GenerableClass {
    final String packageName;
    final String provider;
    final String providerName;
    final String providerMethod;
    final String type;
    final String typeName;
    final boolean expectsContext;
    final String serviceFor;
    final boolean stateless;
    final List<String> annotations;

    public ProducerImplementation(String packageName, String provider, String providedMethod, String type, String typeName, boolean expectsContext, String serviceFor, boolean stateless, List<String> annotations) {
        this.packageName = NameTransformations.stripGenericsFrom(packageName);
        this.provider = NameTransformations.stripGenericsFrom(provider);
        this.providerMethod = NameTransformations.stripGenericsFrom(providedMethod);
        this.type = NameTransformations.stripGenericsFrom(type);
        this.typeName = NameTransformations.stripGenericsFrom(typeName);
        this.expectsContext = expectsContext;
        this.serviceFor = serviceFor;
        this.providerName = String.valueOf(this.createIdentifier());
        this.stateless = stateless;
        this.annotations = annotations;
    }

    private long createIdentifier() {
        int hashCode = String.format("%s%s%s%s%s%s%s", this.packageName, this.provider, this.providerMethod, this.type, this.typeName, this.expectsContext, this.stateless).hashCode();
        return (long)hashCode & 0xFFFFFFFFL;
    }

    public static ProducerImplementation from(ExecutableElement element) {
        ExecutableElement method = ProducerImplementation.assertElementIsMethod(element);
        TypeElement type = (TypeElement)method.getEnclosingElement();
        String providerName = type.getSimpleName().toString();
        String provider = type.asType().toString();
        DeclaredType returnType = (DeclaredType)method.getReturnType();
        String typeAsString = returnType.toString();
        String typeName = returnType.asElement().getSimpleName().toString();
        return new ProducerImplementation(provider.replace("." + providerName, ""), provider, method.getSimpleName().toString(), typeAsString, typeName, ProducerImplementation.measureIfExpectsContextAsParameter(method), SingletonImplementation.getProvidedServiceClassAsStringOrNull(type), false, SingletonImplementation.getQualifierAnnotation(method));
    }

    static boolean measureIfExpectsContextAsParameter(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() == 0) {
            return false;
        }
        VariableElement variableElement = parameters.get(0);
        if (!variableElement.asType().toString().equals(ProviderContext.class.getCanonicalName())) {
            throw new IllegalStateException("@Provider annotated methods should have no parameters, or the parameter should be of type ProviderContext.");
        }
        return true;
    }

    static ExecutableElement assertElementIsMethod(Element element) {
        return (ExecutableElement)element;
    }

    public String packageName() {
        return this.packageName;
    }

    public String provider() {
        return this.provider;
    }

    public String providerMethod() {
        return this.providerMethod;
    }

    public String providerName() {
        return this.providerName;
    }

    public String type() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    @Override
    public String getGeneratedClassCanonicalName() {
        return String.format("%s.%sAutoGeneratedProvider%s", this.packageName(), this.typeName(), this.providerName());
    }
}

