/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.inject.stateless;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ExposedMethod {
    final String name;
    final String returnType;
    final List<String> parameterTypes;

    public ExposedMethod(String name, String returnType, List<String> parameterTypes) {
        this.name = name;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    public boolean getReturnable() {
        return !"void".equals(this.returnType);
    }

    public String getParametersWithTypesAsString() {
        StringBuilder buffer = new StringBuilder();
        int counter = 0;
        for (String type : this.parameterTypes) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(type + " arg" + counter++);
        }
        return buffer.toString();
    }

    public String getParametersAsString() {
        StringBuilder buffer = new StringBuilder();
        for (int counter = 0; counter < this.parameterTypes.size(); ++counter) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append("arg" + counter);
        }
        return buffer.toString();
    }

    public static ExposedMethod from(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        String returnType = method.getReturnType().toString();
        List<String> parameterTypes = ExposedMethod.extractParameters(method);
        return new ExposedMethod(name, returnType, parameterTypes);
    }

    static List<String> extractParameters(ExecutableElement method) {
        ArrayList<String> list = new ArrayList<String>();
        for (VariableElement variableElement : method.getParameters()) {
            list.add(variableElement.asType().toString());
        }
        return list;
    }
}

