/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.inject.stateless;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import trip.spi.PostConstruct;
import trip.spi.PreDestroy;
import trip.spi.inject.GenerableClass;
import trip.spi.inject.SingletonImplementation;
import trip.spi.inject.stateless.ExposedMethod;

public class StatelessClass
implements GenerableClass {
    final long identifaction;
    final String serviceIdentificationName;
    final String packageName;
    final String typeCanonicalName;
    final String typeName;
    final String implementationCanonicalName;
    final boolean exposedByClass;
    final List<ExposedMethod> exposedMethods;
    final List<ExposedMethod> postConstructMethods;
    final List<ExposedMethod> preDestroyMethods;

    public StatelessClass(String serviceIdentificationName, String typeCanonicalName, String implementationCanonicalName, boolean exposedByClass, List<ExposedMethod> exposedMethods, List<ExposedMethod> postConstructMethods, List<ExposedMethod> preDestroyMethods) {
        this.serviceIdentificationName = serviceIdentificationName;
        this.packageName = this.extractPackageNameFrom(implementationCanonicalName);
        this.typeCanonicalName = typeCanonicalName;
        this.typeName = this.extractClassNameFrom(typeCanonicalName);
        this.implementationCanonicalName = implementationCanonicalName;
        this.exposedByClass = exposedByClass;
        this.exposedMethods = exposedMethods;
        this.postConstructMethods = postConstructMethods;
        this.preDestroyMethods = preDestroyMethods;
        this.identifaction = this.createIdentifier();
    }

    private long createIdentifier() {
        int hashCode = String.format("%s%s%s%s%s%s%s", this.packageName, this.serviceIdentificationName, this.typeCanonicalName, this.typeName, this.implementationCanonicalName, this.exposedByClass, this.exposedMethodsAsString()).hashCode();
        return (long)hashCode & 0xFFFFFFFFL;
    }

    private String exposedMethodsAsString() {
        StringBuilder buffer = new StringBuilder();
        for (ExposedMethod method : this.exposedMethods) {
            buffer.append(method.name).append(method.returnType).append(method.getParametersWithTypesAsString());
        }
        return buffer.toString();
    }

    String extractPackageNameFrom(String canonicalName) {
        return canonicalName.replaceFirst("(.*)\\.[^\\.]+", "$1");
    }

    String extractClassNameFrom(String canonicalName) {
        return canonicalName.replaceFirst(".*\\.([^\\.]+)", "$1");
    }

    public Long getIdentifaction() {
        return this.identifaction;
    }

    public String getServiceIdentificationName() {
        return this.serviceIdentificationName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeCanonicalName() {
        return this.typeCanonicalName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getImplementationCanonicalName() {
        return this.implementationCanonicalName;
    }

    public boolean isExposedByClass() {
        return this.exposedByClass;
    }

    public List<ExposedMethod> getExposedMethods() {
        return this.exposedMethods;
    }

    @Override
    public String getGeneratedClassCanonicalName() {
        return String.format("%s.%sStateless%s", this.packageName, this.typeName, this.identifaction);
    }

    public static StatelessClass from(TypeElement type) {
        String serviceIdentificationName = SingletonImplementation.getProvidedServiceName(type);
        String typeCanonicalName = SingletonImplementation.getProvidedServiceClassAsString(type);
        String implementationCanonicalName = type.asType().toString();
        boolean exposedByClass = StatelessClass.isImplementingClass(typeCanonicalName, type);
        List<ExposedMethod> exposedMethods = StatelessClass.retrieveExposedMethods(type);
        return new StatelessClass(serviceIdentificationName, typeCanonicalName, implementationCanonicalName, exposedByClass, exposedMethods, StatelessClass.retrieveMethodsAnnotatedWith(type, PostConstruct.class, javax.annotation.PostConstruct.class), StatelessClass.retrieveMethodsAnnotatedWith(type, PreDestroy.class, javax.annotation.PreDestroy.class));
    }

    public static boolean isImplementingClass(String typeCanonicalName, TypeElement type) {
        while (!Object.class.getCanonicalName().equals(type.asType().toString())) {
            for (TypeMirror typeMirror : type.getInterfaces()) {
                if (!typeCanonicalName.equals(typeMirror.toString())) continue;
                return false;
            }
            type = (TypeElement)((DeclaredType)type.getSuperclass()).asElement();
        }
        return true;
    }

    static List<ExposedMethod> retrieveExposedMethods(TypeElement type) {
        ArrayList<ExposedMethod> list = new ArrayList<ExposedMethod>();
        for (Element element : type.getEnclosedElements()) {
            if (!StatelessClass.isExposedMethod(element)) continue;
            list.add(ExposedMethod.from((ExecutableElement)element));
        }
        return list;
    }

    static List<ExposedMethod> retrieveMethodsAnnotatedWith(TypeElement type, Class<? extends Annotation> ... annotations) {
        ArrayList<ExposedMethod> list = new ArrayList<ExposedMethod>();
        for (Class<? extends Annotation> annotation : annotations) {
            for (Element element : type.getEnclosedElements()) {
                if (!StatelessClass.isExposedMethod(element) || element.getAnnotation(annotation) == null) continue;
                list.add(ExposedMethod.from((ExecutableElement)element));
            }
        }
        return list;
    }

    static boolean isExposedMethod(Element method) {
        return method.getKind().equals((Object)ElementKind.METHOD) && !StatelessClass.isPrivate((ExecutableElement)method);
    }

    static boolean isPrivate(ExecutableElement method) {
        for (Modifier modifier : method.getModifiers()) {
            if (!modifier.equals((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }
}

