/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.inject;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import trip.spi.Singleton;
import trip.spi.Stateless;
import trip.spi.inject.NameTransformations;

public class SingletonImplementation {
    final String interfaceClass;
    final String implementationClass;

    public SingletonImplementation(String interfaceClass, String implementationClass) {
        this.interfaceClass = NameTransformations.stripGenericsFrom(interfaceClass);
        this.implementationClass = NameTransformations.stripGenericsFrom(implementationClass);
    }

    public static SingletonImplementation from(Element element) {
        TypeElement type = (TypeElement)element;
        String interfaceClass = SingletonImplementation.getProvidedServiceClassAsString(type);
        return new SingletonImplementation(interfaceClass, type.asType().toString());
    }

    public static String getProvidedServiceClassAsString(TypeElement type) {
        TypeMirror typeMirror = SingletonImplementation.getProvidedServiceClass(type);
        if (typeMirror == null) {
            return null;
        }
        return typeMirror.toString();
    }

    public static TypeMirror getProvidedServiceClass(TypeElement type) {
        if (SingletonImplementation.isAnnotatedForStateless(type)) {
            return SingletonImplementation.getProvidedServiceClassForStateless(type);
        }
        if (SingletonImplementation.isAnnotatedForSingleton(type)) {
            return SingletonImplementation.getProvidedServiceClassForSingleton(type);
        }
        return null;
    }

    public static String getProvidedServiceName(TypeElement type) {
        if (SingletonImplementation.isAnnotatedForStateless(type)) {
            return type.getAnnotation(Stateless.class).name();
        }
        if (SingletonImplementation.isAnnotatedForSingleton(type)) {
            return type.getAnnotation(Singleton.class).name();
        }
        return null;
    }

    private static boolean isAnnotatedForStateless(TypeElement type) {
        return type.getAnnotation(Stateless.class) != null;
    }

    private static boolean isAnnotatedForSingleton(TypeElement type) {
        return type.getAnnotation(Singleton.class) != null;
    }

    private static TypeMirror getProvidedServiceClassForStateless(TypeElement type) {
        TypeMirror statelessService = SingletonImplementation.getProvidedStatelessAsTypeMirror(type);
        if (SingletonImplementation.isStatelessAnnotationClassBlank(statelessService)) {
            return type.asType();
        }
        return statelessService;
    }

    private static TypeMirror getProvidedStatelessAsTypeMirror(TypeElement type) {
        try {
            Stateless singleton = type.getAnnotation(Stateless.class);
            if (singleton != null) {
                singleton.exposedAs();
            }
            return null;
        }
        catch (MirroredTypeException cause) {
            return cause.getTypeMirror();
        }
    }

    private static boolean isStatelessAnnotationClassBlank(TypeMirror providedClass) {
        return providedClass.toString().equals(Stateless.class.getCanonicalName());
    }

    private static TypeMirror getProvidedServiceClassForSingleton(TypeElement type) {
        TypeMirror providedClass = SingletonImplementation.getProvidedSingletonAsTypeMirror(type);
        if (SingletonImplementation.isSingletonAnnotationBlank(providedClass)) {
            return type.asType();
        }
        return providedClass;
    }

    private static TypeMirror getProvidedSingletonAsTypeMirror(TypeElement type) {
        try {
            Singleton singleton = type.getAnnotation(Singleton.class);
            if (singleton != null) {
                singleton.exposedAs();
            }
            return null;
        }
        catch (MirroredTypeException cause) {
            return cause.getTypeMirror();
        }
    }

    private static boolean isSingletonAnnotationBlank(TypeMirror providedClass) {
        return providedClass.toString().equals(Singleton.class.getCanonicalName());
    }

    public String implementationClass() {
        return this.implementationClass;
    }

    public String interfaceClass() {
        return this.interfaceClass;
    }
}

