/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.inject;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import trip.spi.Producer;
import trip.spi.ProducerFactory;
import trip.spi.Singleton;
import trip.spi.Stateless;
import trip.spi.helpers.cache.ServiceLoader;
import trip.spi.inject.GenerableClass;
import trip.spi.inject.ProducerImplementation;
import trip.spi.inject.SingletonImplementation;
import trip.spi.inject.stateless.StatelessClass;
import trip.spi.inject.stateless.StatelessClassGenerator;

@SupportedAnnotationTypes(value={"trip.spi.*"})
public class ProvidedClassesProcessor
extends AbstractProcessor {
    static final String EOL = "\n";
    static final String SERVICES = "META-INF/services/";
    static final String PROVIDER_FILE = "META-INF/services/" + ProducerFactory.class.getCanonicalName();
    final DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
    final Mustache factoryProviderClazzTemplate = this.mustacheFactory.compile("META-INF/provided-class.mustache");
    final Map<String, Set<String>> singletons = new HashMap<String, Set<String>>();
    final StatelessClassGenerator statelessClassGenerator = new StatelessClassGenerator();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (!roundEnv.processingOver()) {
                this.process(roundEnv);
            } else {
                this.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    void process(RoundEnvironment roundEnv) throws IOException {
        this.processSingletons(roundEnv);
        this.processStateless(roundEnv);
        this.processProducers(roundEnv);
    }

    void processStateless(RoundEnvironment roundEnv) throws IOException {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Stateless.class);
        for (Element element : annotatedElements) {
            if (element.getKind() != ElementKind.CLASS) continue;
            this.memorizeAServiceImplementation(StatelessClass.from((TypeElement)element));
        }
    }

    void memorizeAServiceImplementation(StatelessClass clazz) throws IOException {
        this.createAStatelessClassFrom(clazz);
        String interfaceClass = clazz.getTypeCanonicalName();
        String implementationClass = clazz.getGeneratedClassCanonicalName();
        this.memorizeAServiceImplementation(interfaceClass, implementationClass);
    }

    void createAStatelessClassFrom(StatelessClass clazz) throws IOException {
        String name = clazz.getGeneratedClassCanonicalName();
        if (!this.classExists(name)) {
            this.log("Generating " + name);
            JavaFileObject sourceFile = this.filer().createSourceFile(name, new Element[0]);
            Writer writer = sourceFile.openWriter();
            this.statelessClassGenerator.write(clazz, writer);
            writer.close();
        }
    }

    void processSingletons(RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Singleton.class);
        for (Element element : annotatedElements) {
            if (element.getKind() != ElementKind.CLASS) continue;
            this.memorizeAServiceImplementation(SingletonImplementation.from(element));
        }
    }

    void memorizeAServiceImplementation(SingletonImplementation from) {
        String interfaceClass = from.interfaceClass();
        String implementationClass = from.implementationClass();
        this.memorizeAServiceImplementation(interfaceClass, implementationClass);
    }

    void memorizeAServiceImplementation(String interfaceClass, String implementationClass) {
        Set<String> list = this.singletons.get(interfaceClass);
        if (list == null) {
            list = this.readAListWithAllCreatedClassesImplementing(interfaceClass);
            this.singletons.put(interfaceClass, list);
        }
        list.add(implementationClass);
    }

    private HashSet<String> readAListWithAllCreatedClassesImplementing(String interfaceClass) {
        LinkedHashSet<String> foundSingletons = new LinkedHashSet<String>();
        for (Class implementationClass : ServiceLoader.loadImplementationsFor((String)interfaceClass)) {
            foundSingletons.add(implementationClass.getCanonicalName());
        }
        return foundSingletons;
    }

    void processProducers(RoundEnvironment roundEnv) throws IOException {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Producer.class);
        for (Element element : annotatedElements) {
            if (element.getKind() != ElementKind.METHOD) continue;
            this.createAProducerFrom(ProducerImplementation.from((ExecutableElement)element));
        }
    }

    void createAProducerFrom(GenerableClass clazz) throws IOException {
        String name = clazz.getGeneratedClassCanonicalName();
        if (!this.classExists(name)) {
            this.log("Generating " + name);
            JavaFileObject sourceFile = this.filer().createSourceFile(name, new Element[0]);
            Writer writer = sourceFile.openWriter();
            this.factoryProviderClazzTemplate.execute(writer, (Object)clazz);
            writer.close();
        }
    }

    boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Exception cause) {
            return false;
        }
    }

    String createClassCanonicalName(ProducerImplementation clazz) {
        return String.format("%s.%sAutoGeneratedProvider%s", clazz.packageName(), clazz.typeName(), clazz.providerName());
    }

    void createSingletonMetaInf() throws IOException {
        for (String interfaceClass : this.singletons.keySet()) {
            Writer resource = this.createResource(SERVICES + interfaceClass);
            for (String implementation : this.singletons.get(interfaceClass)) {
                this.log("Exposing " + implementation + " as " + interfaceClass);
                resource.write(implementation + EOL);
            }
            resource.close();
        }
    }

    Writer createResource(String resourcePath) throws IOException {
        FileObject resource = this.filer().getResource(StandardLocation.CLASS_OUTPUT, "", resourcePath);
        URI uri = resource.toUri();
        this.createNeededDirectoriesTo(uri);
        File file = this.createFile(uri);
        return new FileWriter(file);
    }

    void createNeededDirectoriesTo(URI uri) {
        File dir = null;
        dir = uri.isAbsolute() ? new File(uri).getParentFile() : new File(uri.toString()).getParentFile();
        dir.mkdirs();
    }

    File createFile(URI uri) throws IOException {
        File file = new File(uri);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    Filer filer() {
        return this.processingEnv.getFiler();
    }

    private void log(String msg) {
        System.out.println(msg);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, msg);
    }

    void flush() throws IOException {
        if (!this.singletons.isEmpty()) {
            this.createSingletonMetaInf();
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.values()[SourceVersion.values().length - 1];
    }
}

