/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.inject;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import trip.spi.Producer;
import trip.spi.ProviderContext;
import trip.spi.Stateless;
import trip.spi.inject.GenerableClass;
import trip.spi.inject.NameTransformations;
import trip.spi.inject.SingletonImplementation;

public class ProducerImplementation
implements GenerableClass {
    final String packageName;
    final String provider;
    final String providerName;
    final String providerMethod;
    final String type;
    final String typeName;
    final String name;
    final boolean expectsContext;
    final String serviceFor;
    final boolean stateless;

    public ProducerImplementation(String packageName, String provider, String providedMethod, String type, String typeName, String name, boolean expectsContext, String serviceFor, boolean stateless) {
        this.packageName = NameTransformations.stripGenericsFrom(packageName);
        this.provider = NameTransformations.stripGenericsFrom(provider);
        this.providerMethod = NameTransformations.stripGenericsFrom(providedMethod);
        this.type = NameTransformations.stripGenericsFrom(type);
        this.typeName = NameTransformations.stripGenericsFrom(typeName);
        this.name = name;
        this.expectsContext = expectsContext;
        this.serviceFor = serviceFor;
        this.providerName = String.valueOf(this.createIdentifier());
        this.stateless = stateless;
    }

    private long createIdentifier() {
        int hashCode = String.format("%s%s%s%s%s%s%s%s", this.packageName, this.provider, this.providerMethod, this.type, this.typeName, this.name, this.expectsContext, this.stateless).hashCode();
        return (long)hashCode & 0xFFFFFFFFL;
    }

    public static ProducerImplementation from(ExecutableElement element) {
        ExecutableElement method = ProducerImplementation.assertElementIsMethod(element);
        TypeElement type = (TypeElement)method.getEnclosingElement();
        String providerName = type.getSimpleName().toString();
        String provider = type.asType().toString();
        DeclaredType returnType = (DeclaredType)method.getReturnType();
        String typeAsString = returnType.toString();
        String typeName = returnType.asElement().getSimpleName().toString();
        return new ProducerImplementation(provider.replace("." + providerName, ""), provider, method.getSimpleName().toString(), typeAsString, typeName, ProducerImplementation.extractNameFrom(method), ProducerImplementation.measureIfExpectsContextAsParameter(method), SingletonImplementation.getProvidedServiceClassAsString(type), false);
    }

    static boolean measureIfExpectsContextAsParameter(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() == 0) {
            return false;
        }
        VariableElement variableElement = parameters.get(0);
        if (!variableElement.asType().toString().equals(ProviderContext.class.getCanonicalName())) {
            throw new IllegalStateException("@Provider annotated methods should have no parameters, or the parameter should be of type ProviderContext.");
        }
        return true;
    }

    static String extractNameFrom(ExecutableElement element) {
        Producer producer = element.getAnnotation(Producer.class);
        if (!producer.name().isEmpty()) {
            return producer.name();
        }
        return null;
    }

    static String extractNameFrom(TypeElement element) {
        Stateless stateless = element.getAnnotation(Stateless.class);
        if (!stateless.name().isEmpty()) {
            return stateless.name();
        }
        return null;
    }

    static ExecutableElement assertElementIsMethod(Element element) {
        return (ExecutableElement)element;
    }

    public String packageName() {
        return this.packageName;
    }

    public String provider() {
        return this.provider;
    }

    public String providerMethod() {
        return this.providerMethod;
    }

    public String providerName() {
        return this.providerName;
    }

    public String type() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String getGeneratedClassCanonicalName() {
        return String.format("%s.%sAutoGeneratedProvider%s", this.packageName(), this.typeName(), this.providerName());
    }
}

