/*
 * Decompiled with CFR 0.152.
 */
package trip.jsr.cdi;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import trip.jsr.cdi.CDILoaderOfClasses;

@SupportedAnnotationTypes(value={"javax.inject.*"})
public class OptionalCDIProcessor
extends AbstractProcessor {
    private static final String DEFAULT_PROCESSOR = "trip.spi.processor.SPIProcessor";
    AbstractProcessor cdiProcessor;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (CDILoaderOfClasses.isClassPresent(DEFAULT_PROCESSOR)) {
            this.cdiProcessor = CDILoaderOfClasses.newInstanceOf("trip.jsr.cdi.CDIProcessor", AbstractProcessor.class);
            this.cdiProcessor.init(processingEnv);
        } else {
            this.warn("CDIProcessor disabled");
        }
    }

    private void warn(String msg) {
        System.out.println("[WARN] " + msg);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.cdiProcessor != null) {
            return this.cdiProcessor.process(annotations, roundEnv);
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.values()[SourceVersion.values().length - 1];
    }
}

