/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.tests.concurrency;

import java.beans.ConstructorProperties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import trip.spi.DefaultServiceProvider;
import trip.spi.ServiceProviderException;
import trip.spi.tests.concurrency.StatelessService;

public class PrinterRunner
implements Runnable {
    final BlockingQueue<Object> events;
    final DefaultServiceProvider provider;
    final CountDownLatch couter;

    @Override
    public void run() {
        try {
            Object last = null;
            while (last == null || !last.equals("END")) {
                last = this.nextEvent();
                this.instantiateService().printNames();
            }
        }
        catch (Throwable cause) {
            cause.printStackTrace();
        }
    }

    Object nextEvent() throws InterruptedException {
        try {
            Object object = this.events.take();
            return object;
        }
        finally {
            this.couter.countDown();
        }
    }

    StatelessService instantiateService() {
        try {
            return (StatelessService)this.provider.load(StatelessService.class);
        }
        catch (ServiceProviderException e) {
            throw new RuntimeException(e);
        }
    }

    @ConstructorProperties(value={"events", "provider", "couter"})
    public PrinterRunner(BlockingQueue<Object> events, DefaultServiceProvider provider, CountDownLatch couter) {
        this.events = events;
        this.provider = provider;
        this.couter = couter;
    }
}

