/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers.filter;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Collection;
import trip.spi.helpers.filter.Condition;

public class QualifierCondition<T>
implements Condition<T> {
    final Collection<Class<? extends Annotation>> qualifiers;

    @Override
    public boolean check(T object) {
        Class<?> targetClass = object.getClass();
        for (Class<? extends Annotation> ann : this.qualifiers) {
            if (targetClass.isAnnotationPresent(ann)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Qualifiers(" + this.qualifiers + ")";
    }

    @ConstructorProperties(value={"qualifiers"})
    public QualifierCondition(Collection<Class<? extends Annotation>> qualifiers) {
        this.qualifiers = qualifiers;
    }
}

