/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import trip.spi.helpers.FieldQualifierExtractor;

public class QualifierExtractor {
    final Iterable<FieldQualifierExtractor> extractors;

    public Collection<Class<? extends Annotation>> extractQualifiersFrom(Field field) {
        ArrayList<Class<? extends Annotation>> anns = new ArrayList<Class<? extends Annotation>>();
        for (FieldQualifierExtractor extractor : this.extractors) {
            anns.addAll(extractor.extractQualifiersFrom(field));
        }
        return anns;
    }

    public boolean isAnnotatedWithQualifierAnnotation(Class<? extends Annotation> ann) {
        for (FieldQualifierExtractor extractor : this.extractors) {
            if (!extractor.isAnnotatedWithQualifierAnnotation(ann)) continue;
            return true;
        }
        return false;
    }

    public boolean isASingleElementProvider(Field field) {
        for (FieldQualifierExtractor extractor : this.extractors) {
            if (!extractor.isASingleElementProvider(field)) continue;
            return true;
        }
        return false;
    }

    public boolean isAManyElementsProvider(Field field) {
        for (FieldQualifierExtractor extractor : this.extractors) {
            if (!extractor.isAManyElementsProvider(field)) continue;
            return true;
        }
        return false;
    }

    @ConstructorProperties(value={"extractors"})
    public QualifierExtractor(Iterable<FieldQualifierExtractor> extractors) {
        this.extractors = extractors;
    }
}

