/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;

public class LazyClassReader<S>
implements Iterator<Class<S>> {
    private static final String PREFIX = "META-INF/services/";
    private static final int NOT_FOUND = -1;
    final List<Class<S>> cache = new ArrayList<Class<S>>();
    final String serviceClassCanonicalName;
    final ClassLoader loader;
    final Enumeration<URL> resources;
    Iterator<String> currentResourceLines;

    public LazyClassReader(Class<S> serviceClass, ClassLoader loader) {
        this(serviceClass.getCanonicalName(), loader);
    }

    public LazyClassReader(String serviceClassCanonicalName, ClassLoader loader) {
        this.serviceClassCanonicalName = serviceClassCanonicalName;
        this.loader = loader;
        this.resources = this.readAllServiceResources();
    }

    Enumeration<URL> readAllServiceResources() {
        try {
            String fullName = PREFIX + this.serviceClassCanonicalName;
            return this.loader.getResources(fullName);
        }
        catch (IOException cause) {
            throw new ServiceConfigurationError(this.serviceClassCanonicalName + ": " + cause.getMessage(), cause);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.currentResourceLines == null || !this.currentResourceLines.hasNext()) {
                this.readNextResourceFile();
            }
            return this.currentResourceLines != null && this.currentResourceLines.hasNext();
        }
        catch (FileNotFoundException cause) {
            return false;
        }
        catch (IOException cause) {
            throw new IllegalStateException(cause);
        }
    }

    void readNextResourceFile() throws IOException {
        if (this.getResources().hasMoreElements()) {
            URL nextElement = this.getResources().nextElement();
            this.currentResourceLines = this.readLines(nextElement);
        }
    }

    @Override
    public Class<S> next() {
        String classCanonicalName = this.currentResourceLines.next();
        try {
            Class<?> clazz = Class.forName(classCanonicalName, false, this.loader);
            this.cache.add(clazz);
            return clazz;
        }
        catch (ClassNotFoundException cause) {
            throw new IllegalStateException("Could not read class " + classCanonicalName, cause);
        }
        catch (NoClassDefFoundError cause) {
            throw new IllegalStateException("Could not read class " + classCanonicalName, cause);
        }
    }

    @Override
    public void remove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<String> readLines(URL url) throws IOException {
        InputStream inputStream = url.openStream();
        try {
            Iterator<String> iterator;
            block9: {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                try {
                    ArrayList<String> lines = new ArrayList<String>();
                    String line = null;
                    while ((line = this.readNextLine(reader)) != null) {
                        lines.add(line);
                    }
                    iterator = lines.iterator();
                    if (Collections.singletonList(reader).get(0) == null) break block9;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
            }
            return iterator;
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                inputStream.close();
            }
        }
    }

    String readNextLine(BufferedReader reader) throws IOException {
        String ln = reader.readLine();
        if (ln != null && !this.isValidClassName(ln)) {
            throw new IOException("Invalid class name: " + ln);
        }
        return ln;
    }

    boolean isValidClassName(String className) {
        return className.indexOf(32) == -1 && className.indexOf(9) == -1;
    }

    public List<Class<S>> getCache() {
        return this.cache;
    }

    public String getServiceClassCanonicalName() {
        return this.serviceClassCanonicalName;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Enumeration<URL> getResources() {
        return this.resources;
    }

    public Iterator<String> getCurrentResourceLines() {
        return this.currentResourceLines;
    }
}

