/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.logging.Logger;
import trip.spi.Provided;
import trip.spi.ProviderContext;
import trip.spi.ServiceProvider;
import trip.spi.ServiceProviderException;
import trip.spi.helpers.FieldProviderContext;
import trip.spi.helpers.ProvidableField;
import trip.spi.helpers.filter.ChainedCondition;
import trip.spi.helpers.filter.Condition;
import trip.spi.helpers.filter.IsAssignableFrom;
import trip.spi.helpers.filter.QualifierCondition;

public final class SingleElementProvidableField<T>
implements ProvidableField {
    private static final Logger log = Logger.getLogger(SingleElementProvidableField.class.getName());
    private final Field field;
    private final Class<T> fieldType;
    private final Condition<T> condition;
    private final ProviderContext providerContext;

    @Override
    public void provide(Object instance, ServiceProvider provider) throws ServiceProviderException, IllegalArgumentException, IllegalAccessException {
        T value = provider.load(this.fieldType, this.condition, this.providerContext);
        if (value == null) {
            log.warning("No data found for " + this.fieldType.getCanonicalName() + ". Condition: " + this.condition);
        }
        this.set(instance, value);
    }

    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(instance, value);
    }

    public static <T> ProvidableField from(Collection<Class<? extends Annotation>> qualifiers, Field field) {
        field.setAccessible(true);
        Provided provided = field.getAnnotation(Provided.class);
        Class<?> expectedClass = provided == null || provided.exposedAs().equals(Provided.class) ? field.getType() : provided.exposedAs();
        return new SingleElementProvidableField(field, expectedClass, SingleElementProvidableField.createInjectionCondition(qualifiers, field), new FieldProviderContext(qualifiers, field));
    }

    private static <T> Condition<T> createInjectionCondition(Collection<Class<? extends Annotation>> qualifiers, Field field) {
        ChainedCondition<Object> condition = new ChainedCondition<Object>();
        condition.add(new IsAssignableFrom(field.getType()));
        condition.add(new QualifierCondition(qualifiers));
        return condition;
    }

    @ConstructorProperties(value={"field", "fieldType", "condition", "providerContext"})
    public SingleElementProvidableField(Field field, Class<T> fieldType, Condition<T> condition, ProviderContext providerContext) {
        this.field = field;
        this.fieldType = fieldType;
        this.condition = condition;
        this.providerContext = providerContext;
    }

    public Field getField() {
        return this.field;
    }

    public Class<T> getFieldType() {
        return this.fieldType;
    }

    public Condition<T> getCondition() {
        return this.condition;
    }

    public ProviderContext getProviderContext() {
        return this.providerContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleElementProvidableField)) {
            return false;
        }
        SingleElementProvidableField other = (SingleElementProvidableField)o;
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        Class<T> this$fieldType = this.getFieldType();
        Class<T> other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        Condition<T> this$condition = this.getCondition();
        Condition<T> other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        ProviderContext this$providerContext = this.getProviderContext();
        ProviderContext other$providerContext = other.getProviderContext();
        return !(this$providerContext == null ? other$providerContext != null : !this$providerContext.equals(other$providerContext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 0 : ((Object)$field).hashCode());
        Class<T> $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 0 : $fieldType.hashCode());
        Condition<T> $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 0 : $condition.hashCode());
        ProviderContext $providerContext = this.getProviderContext();
        result = result * 59 + ($providerContext == null ? 0 : $providerContext.hashCode());
        return result;
    }

    public String toString() {
        return "SingleElementProvidableField(field=" + this.getField() + ", fieldType=" + this.getFieldType() + ", condition=" + this.getCondition() + ", providerContext=" + this.getProviderContext() + ")";
    }
}

