/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import trip.spi.helpers.LazyClassReader;

public abstract class ServiceLoader {
    public static <T> List<Class<T>> loadImplementationsFor(Class<T> clazz) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LazyClassReader<T> reader = new LazyClassReader<T>(clazz, cl);
        return ServiceLoader.readAndConvertToList(reader);
    }

    public static <T> List<Class<T>> loadImplementationsFor(String clazz) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LazyClassReader reader = new LazyClassReader(clazz, cl);
        return ServiceLoader.readAndConvertToList(reader);
    }

    private static <T> List<Class<T>> readAndConvertToList(Iterator<Class<T>> reader) {
        ArrayList<Class<T>> list = new ArrayList<Class<T>>();
        while (reader.hasNext()) {
            try {
                list.add(reader.next());
            }
            catch (IllegalStateException cause) {}
        }
        return list;
    }
}

