/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import trip.spi.GeneratedFromStatelessService;
import trip.spi.ServiceProvider;
import trip.spi.ServiceProviderException;
import trip.spi.helpers.EmptyMethod;
import trip.spi.helpers.ManyElementsProvidableField;
import trip.spi.helpers.PostConstructorMethod;
import trip.spi.helpers.ProvidableField;
import trip.spi.helpers.QualifierExtractor;
import trip.spi.helpers.SingleElementProvidableField;

public class ProvidableClass<T> {
    final Class<T> targetClazz;
    final Iterable<ProvidableField> fields;
    final Consumer<Object> postConstructor;

    public void provide(Object instance, ServiceProvider provider) throws ServiceProviderException, IllegalArgumentException, IllegalAccessException {
        for (ProvidableField field : this.fields) {
            field.provide(instance, provider);
        }
        this.postConstructor.accept(instance);
    }

    public static <T> ProvidableClass<T> wrap(QualifierExtractor extractor, Class<T> targetClazz) {
        return new ProvidableClass<T>(targetClazz, ProvidableClass.readClassProvidableFields(extractor, targetClazz), ProvidableClass.readPostConstructor(targetClazz));
    }

    static Consumer<Object> readPostConstructor(Class<?> targetClazz) {
        Method postConstructor = null;
        for (Method method : targetClazz.getMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            postConstructor = method;
            break;
        }
        return postConstructor != null ? new PostConstructorMethod(postConstructor) : EmptyMethod.INSTANCE;
    }

    static Iterable<ProvidableField> readClassProvidableFields(QualifierExtractor extractor, Class<?> targetClazz) {
        ArrayList<ProvidableField> providableFields = new ArrayList<ProvidableField>();
        Class<?> clazz = targetClazz;
        while (!Object.class.equals(clazz)) {
            ProvidableClass.populateWithProvidableFields(extractor, clazz, providableFields);
            if (clazz.isAnnotationPresent(GeneratedFromStatelessService.class)) break;
            clazz = clazz.getSuperclass();
        }
        return providableFields;
    }

    static void populateWithProvidableFields(QualifierExtractor extractor, Class<?> targetClazz, List<ProvidableField> providableFields) {
        for (Field field : targetClazz.getDeclaredFields()) {
            Collection<Class<? extends Annotation>> qualifiers = ProvidableClass.extractQualifiersFromAvoidingNPEWhenCreatingQualifierExtractor(extractor, field);
            if (extractor.isASingleElementProvider(field)) {
                providableFields.add(SingleElementProvidableField.from(qualifiers, field));
                continue;
            }
            if (!extractor.isAManyElementsProvider(field)) continue;
            providableFields.add(ManyElementsProvidableField.from(qualifiers, field));
        }
    }

    private static Collection<Class<? extends Annotation>> extractQualifiersFromAvoidingNPEWhenCreatingQualifierExtractor(QualifierExtractor extractor, Field field) {
        if (null == extractor) {
            return Collections.emptyList();
        }
        return extractor.extractQualifiersFrom(field);
    }

    @ConstructorProperties(value={"targetClazz", "fields", "postConstructor"})
    public ProvidableClass(Class<T> targetClazz, Iterable<ProvidableField> fields, Consumer<Object> postConstructor) {
        this.targetClazz = targetClazz;
        this.fields = fields;
        this.postConstructor = postConstructor;
    }
}

