/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import trip.spi.ProducerFactory;
import trip.spi.helpers.filter.Condition;
import trip.spi.helpers.filter.Filter;

public class ProducerFactoryMap
implements Map<Class<?>, List<ProducerFactory<?>>> {
    final Map<Class<?>, List<ProducerFactory<?>>> map = new HashMap();

    public static ProducerFactoryMap from(Iterable<ProducerFactory> iterable) {
        ProducerFactoryMap providers = new ProducerFactoryMap();
        for (ProducerFactory provider : iterable) {
            Class<?> clazz = ProducerFactoryMap.getGenericClassFrom(provider);
            providers.memorizeProviderForClazz(provider, clazz);
        }
        return providers;
    }

    private static Class<?> getGenericClassFrom(ProducerFactory<?> provider) {
        Type[] types;
        for (Type type : types = provider.getClass().getGenericInterfaces()) {
            if (!((ParameterizedType)type).getRawType().equals(ProducerFactory.class)) continue;
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    public void memorizeProviderForClazz(ProducerFactory<?> provider, Class<?> clazz) {
        List<ProducerFactory<?>> iterable = this.map.get(clazz);
        if (iterable == null) {
            iterable = new ArrayList();
            this.map.put(clazz, iterable);
        }
        iterable.add(provider);
    }

    public ProducerFactory<?> get(Class<?> clazz, Condition<?> condition) {
        Object list = this.get(clazz);
        if (list == null) {
            return null;
        }
        return (ProducerFactory)Filter.first(list, condition);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.map.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.map.containsValue(arg0);
    }

    @Override
    public List<ProducerFactory<?>> get(Object arg0) {
        return this.map.get(arg0);
    }

    @Override
    public List<ProducerFactory<?>> put(Class<?> arg0, List<ProducerFactory<?>> arg1) {
        return this.map.put(arg0, arg1);
    }

    @Override
    public List<ProducerFactory<?>> remove(Object arg0) {
        return this.map.remove(arg0);
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends List<ProducerFactory<?>>> arg0) {
        this.map.putAll(arg0);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Class<?>> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<ProducerFactory<?>>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Class<?>, List<ProducerFactory<?>>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public List<ProducerFactory<?>> getOrDefault(Object arg0, List<ProducerFactory<?>> arg1) {
        return this.map.getOrDefault(arg0, arg1);
    }

    @Override
    public void forEach(BiConsumer<? super Class<?>, ? super List<ProducerFactory<?>>> arg0) {
        this.map.forEach(arg0);
    }

    @Override
    public void replaceAll(BiFunction<? super Class<?>, ? super List<ProducerFactory<?>>, ? extends List<ProducerFactory<?>>> arg0) {
        this.map.replaceAll(arg0);
    }

    @Override
    public List<ProducerFactory<?>> putIfAbsent(Class<?> arg0, List<ProducerFactory<?>> arg1) {
        return this.map.putIfAbsent(arg0, arg1);
    }

    @Override
    public boolean remove(Object arg0, Object arg1) {
        return this.map.remove(arg0, arg1);
    }

    @Override
    public boolean replace(Class<?> arg0, List<ProducerFactory<?>> arg1, List<ProducerFactory<?>> arg2) {
        return this.map.replace(arg0, arg1, arg2);
    }

    @Override
    public List<ProducerFactory<?>> replace(Class<?> arg0, List<ProducerFactory<?>> arg1) {
        return this.map.replace(arg0, arg1);
    }

    @Override
    public List<ProducerFactory<?>> computeIfAbsent(Class<?> arg0, Function<? super Class<?>, ? extends List<ProducerFactory<?>>> arg1) {
        return this.map.computeIfAbsent(arg0, arg1);
    }

    @Override
    public List<ProducerFactory<?>> computeIfPresent(Class<?> arg0, BiFunction<? super Class<?>, ? super List<ProducerFactory<?>>, ? extends List<ProducerFactory<?>>> arg1) {
        return this.map.computeIfPresent(arg0, arg1);
    }

    @Override
    public List<ProducerFactory<?>> compute(Class<?> arg0, BiFunction<? super Class<?>, ? super List<ProducerFactory<?>>, ? extends List<ProducerFactory<?>>> arg1) {
        return this.map.compute(arg0, arg1);
    }

    @Override
    public List<ProducerFactory<?>> merge(Class<?> arg0, List<ProducerFactory<?>> arg1, BiFunction<? super List<ProducerFactory<?>>, ? super List<ProducerFactory<?>>, ? extends List<ProducerFactory<?>>> arg2) {
        return this.map.merge(arg0, arg1, arg2);
    }
}

