/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import trip.spi.ProvidedServices;
import trip.spi.ServiceProvider;
import trip.spi.ServiceProviderException;
import trip.spi.helpers.ProvidableField;
import trip.spi.helpers.filter.Condition;
import trip.spi.helpers.filter.QualifierCondition;

public class ManyElementsProvidableField<T>
implements ProvidableField {
    final Field field;
    final Class<T> fieldType;
    final Condition<T> condition;

    @Override
    public void provide(Object instance, ServiceProvider provider) throws ServiceProviderException, IllegalArgumentException, IllegalAccessException {
        Iterable<T> value = provider.loadAll(this.fieldType, this.condition);
        this.set(instance, value);
    }

    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(instance, value);
    }

    public static <T> ProvidableField from(Collection<Class<? extends Annotation>> qualifiers, Field field) {
        ManyElementsProvidableField.assertFieldTypeIsIterable(field);
        field.setAccessible(true);
        ProvidedServices provided = field.getAnnotation(ProvidedServices.class);
        return new ManyElementsProvidableField(field, provided.exposedAs(), new QualifierCondition(qualifiers));
    }

    private static void assertFieldTypeIsIterable(Field field) {
        if (!Iterable.class.equals(field.getType())) {
            throw new IllegalStateException("Field " + field.getName() + " expects to have Iterable type.");
        }
    }

    @ConstructorProperties(value={"field", "fieldType", "condition"})
    public ManyElementsProvidableField(Field field, Class<T> fieldType, Condition<T> condition) {
        this.field = field;
        this.fieldType = fieldType;
        this.condition = condition;
    }
}

