/*
 * Decompiled with CFR 0.152.
 */
package trip.spi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import trip.spi.ProducerFactory;
import trip.spi.ProviderContext;
import trip.spi.ServiceProvider;
import trip.spi.ServiceProviderException;
import trip.spi.SingletonContext;
import trip.spi.StartupListener;
import trip.spi.helpers.EmptyIterable;
import trip.spi.helpers.EmptyProviderContext;
import trip.spi.helpers.FieldQualifierExtractor;
import trip.spi.helpers.ProducerFactoryMap;
import trip.spi.helpers.ProvidableClass;
import trip.spi.helpers.QualifierExtractor;
import trip.spi.helpers.ServiceLoader;
import trip.spi.helpers.SingleObjectIterable;
import trip.spi.helpers.filter.AnyObject;
import trip.spi.helpers.filter.Condition;
import trip.spi.helpers.filter.Filter;

public class DefaultServiceProvider
implements ServiceProvider {
    final SingletonContext singletonContext = new SingletonContext();
    final Map<Class<?>, ProvidableClass<?>> providableClassCache = new HashMap();
    final Map<Class<?>, Iterable<Class<?>>> implementedClasses = new HashMap();
    final QualifierExtractor qualifierExtractor;
    final Map<Class<?>, Iterable<?>> providers = this.createDefaultProvidedData();
    final ProducerFactoryMap producers;

    public DefaultServiceProvider() {
        this.qualifierExtractor = this.createQualifierExtractor();
        this.runHookBeforeProducersAreReady();
        this.producers = this.loadAllProducers();
        this.runAllStartupListeners();
    }

    private QualifierExtractor createQualifierExtractor() {
        Iterable<FieldQualifierExtractor> extractors = this.loadAll(FieldQualifierExtractor.class);
        return new QualifierExtractor(extractors);
    }

    private void runHookBeforeProducersAreReady() {
        Iterable<StartupListener> startupListeners = this.loadAll(StartupListener.class);
        for (StartupListener listener : startupListeners) {
            listener.beforeProducersReady(this);
        }
    }

    private void runAllStartupListeners() {
        Iterable<StartupListener> startupListeners = this.loadAll(StartupListener.class);
        for (StartupListener listener : startupListeners) {
            listener.onStartup(this);
        }
    }

    protected Map<Class<?>, Iterable<?>> createDefaultProvidedData() {
        HashMap injectables = new HashMap();
        injectables.put(ServiceProvider.class, new SingleObjectIterable<DefaultServiceProvider>(this));
        return injectables;
    }

    protected ProducerFactoryMap loadAllProducers() {
        return ProducerFactoryMap.from(this.loadAll(ProducerFactory.class));
    }

    @Override
    public <T> T load(Class<T> interfaceClazz) {
        return this.load(interfaceClazz, AnyObject.instance());
    }

    @Override
    public <T> T load(Class<T> interfaceClazz, Condition<T> condition) {
        return this.load(interfaceClazz, condition, EmptyProviderContext.INSTANCE);
    }

    @Override
    public <T> T load(Class<T> interfaceClazz, ProviderContext context) {
        return this.load(interfaceClazz, AnyObject.instance(), context);
    }

    @Override
    public <T> T load(Class<T> interfaceClazz, Condition<T> condition, ProviderContext context) throws ServiceProviderException {
        T produced = this.produceFromFactory(interfaceClazz, condition, context);
        if (produced != null) {
            return produced;
        }
        return Filter.first(this.loadAll(interfaceClazz, condition), condition);
    }

    @Override
    public <T> Iterable<T> loadAll(Class<T> interfaceClazz, Condition<T> condition) {
        return Filter.filter(this.loadAll(interfaceClazz), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Iterable<T> loadAll(Class<T> interfaceClazz) {
        Iterable<Object> iterable = this.providers.get(interfaceClazz);
        if (iterable == null) {
            Map<Class<?>, Iterable<?>> map = this.providers;
            synchronized (map) {
                iterable = this.providers.get(interfaceClazz);
                if (iterable == null) {
                    iterable = this.loadAllServicesImplementingTheInterface(interfaceClazz);
                }
            }
        }
        return iterable;
    }

    protected <T> Iterable<T> loadAllServicesImplementingTheInterface(Class<T> interfaceClazz) {
        try {
            Iterable<T> iterable = this.loadServiceProvidersFor(interfaceClazz);
            this.provideOn(iterable);
            this.providerFor(interfaceClazz, iterable);
            return iterable;
        }
        catch (StackOverflowError cause) {
            throw new ServiceConfigurationError("Could not load implementations of " + interfaceClazz.getCanonicalName() + ": Recursive dependency injection detected.");
        }
    }

    protected <T> Iterable<T> loadServiceProvidersFor(Class<T> interfaceClazz) {
        List<Class<T>> iterableInterfaces = this.loadClassesImplementing(interfaceClazz);
        if (!iterableInterfaces.isEmpty()) {
            return this.singletonContext.instantiate(iterableInterfaces);
        }
        T instance = this.singletonContext.instantiate(interfaceClazz);
        if (instance != null) {
            return new SingleObjectIterable<T>(instance);
        }
        return EmptyIterable.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Class<T>> loadClassesImplementing(Class<T> interfaceClazz) {
        List<Class<T>> implementations = (List<Class<T>>)this.implementedClasses.get(interfaceClazz);
        if (implementations == null) {
            Map<Class<?>, Iterable<Class<?>>> map = this.implementedClasses;
            synchronized (map) {
                implementations = (List)this.implementedClasses.get(interfaceClazz);
                if (implementations == null) {
                    implementations = ServiceLoader.loadImplementationsFor(interfaceClazz);
                    this.implementedClasses.put(interfaceClazz, implementations);
                }
            }
        }
        return implementations;
    }

    @Override
    public <T> void providerFor(Class<T> interfaceClazz, ProducerFactory<T> provider) {
        this.producers.memorizeProviderForClazz(provider, interfaceClazz);
    }

    @Override
    public <T> void providerFor(Class<T> interfaceClazz, T object) {
        this.providerFor(interfaceClazz, new SingleObjectIterable<T>(object));
    }

    protected <T> void providerFor(Class<T> interfaceClazz, Iterable<T> iterable) {
        this.providers.put(interfaceClazz, iterable);
    }

    @Override
    public <T> void provideOn(Iterable<T> iterable) {
        for (T object : iterable) {
            this.provideOn(object);
        }
    }

    @Override
    public void provideOn(Object object) {
        try {
            ProvidableClass<?> providableClass = this.retrieveProvidableClass(object.getClass());
            providableClass.provide(object, this);
        }
        catch (Exception cause) {
            throw new ServiceProviderException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProvidableClass<?> retrieveProvidableClass(Class<?> targetClazz) {
        ProvidableClass<?> providableClass = this.providableClassCache.get(targetClazz);
        if (providableClass == null) {
            Map<Class<?>, ProvidableClass<?>> map = this.providableClassCache;
            synchronized (map) {
                providableClass = this.providableClassCache.get(targetClazz);
                if (providableClass == null) {
                    providableClass = ProvidableClass.wrap(this.qualifierExtractor, targetClazz);
                    this.providableClassCache.put(targetClazz, providableClass);
                }
            }
        }
        return providableClass;
    }

    private <T> T produceFromFactory(Class<T> interfaceClazz, Condition<T> condition, ProviderContext context) {
        ProducerFactory<T> provider = this.getProviderFor(interfaceClazz, condition);
        if (provider != null) {
            return provider.provide(context);
        }
        return null;
    }

    public <T> ProducerFactory<T> getProviderFor(Class<T> interfaceClazz, Condition<T> condition) {
        if (this.producers == null) {
            return null;
        }
        return this.producers.get(interfaceClazz, condition);
    }

    public QualifierExtractor getQualifierExtractor() {
        return this.qualifierExtractor;
    }
}

