/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers.cache;

import trip.spi.helpers.cache.CachedIterable;
import trip.spi.helpers.cache.LazyClassInstantor;
import trip.spi.helpers.cache.LazyClassReader;

public class ServiceLoader {
    public static <T> CachedIterable<Class<T>> loadImplementationsFor(Class<T> clazz) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LazyClassReader<T> reader = new LazyClassReader<T>(clazz, cl);
        return new CachedIterable<Class<T>>(reader);
    }

    public static <T> CachedIterable<Class<T>> loadImplementationsFor(String interfaceCanonicalName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LazyClassReader reader = new LazyClassReader(interfaceCanonicalName, cl);
        return new CachedIterable<Class<T>>(reader);
    }

    public static <T> CachedIterable<T> loadFrom(Iterable<Class<T>> interfaces) {
        LazyClassInstantor<T> instantor = new LazyClassInstantor<T>(interfaces.iterator());
        return new CachedIterable<T>(instantor);
    }
}

