/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers.cache;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class LazyClassInstantor<T>
implements Iterator<T> {
    private static final Logger log = Logger.getLogger(LazyClassInstantor.class.getName());
    final Iterator<Class<T>> reader;
    List<T> cache = new ArrayList<T>();

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public T next() {
        try {
            Class<T> clazz = this.reader.next();
            T instance = clazz.newInstance();
            this.cache.add(instance);
            return instance;
        }
        catch (IllegalAccessException cause) {
            log.warning(cause.getMessage());
            throw new IllegalStateException(cause);
        }
        catch (InstantiationException cause) {
            log.warning(cause.getMessage());
            throw new IllegalStateException(cause);
        }
    }

    @Override
    public void remove() {
        this.reader.remove();
    }

    public Iterator<Class<T>> getReader() {
        return this.reader;
    }

    public List<T> getCache() {
        return this.cache;
    }

    @ConstructorProperties(value={"reader"})
    public LazyClassInstantor(Iterator<Class<T>> reader) {
        this.reader = reader;
    }
}

