/*
 * Decompiled with CFR 0.152.
 */
package trip.spi.helpers;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import trip.spi.GeneratedFromStatelessService;
import trip.spi.Provided;
import trip.spi.ProvidedServices;
import trip.spi.ServiceProvider;
import trip.spi.ServiceProviderException;
import trip.spi.helpers.ManyElementsProvidableField;
import trip.spi.helpers.ProvidableField;
import trip.spi.helpers.SingleElementProvidableField;

public class ProvidableClass<T> {
    final Class<T> targetClazz;
    final Iterable<ProvidableField> fields;

    public void provide(Object instance, ServiceProvider provider) throws ServiceProviderException, IllegalArgumentException, IllegalAccessException {
        for (ProvidableField field : this.fields) {
            field.provide(instance, provider);
        }
    }

    public static <T> ProvidableClass<T> wrap(Class<T> targetClazz) {
        return new ProvidableClass<T>(targetClazz, ProvidableClass.readClassProvidableFields(targetClazz));
    }

    static Iterable<ProvidableField> readClassProvidableFields(Class<?> targetClazz) {
        ArrayList<ProvidableField> providableFields = new ArrayList<ProvidableField>();
        Class<?> clazz = targetClazz;
        while (!Object.class.equals(clazz)) {
            ProvidableClass.populateWithProvidableFields(clazz, providableFields);
            if (clazz.isAnnotationPresent(GeneratedFromStatelessService.class)) break;
            clazz = clazz.getSuperclass();
        }
        return providableFields;
    }

    static void populateWithProvidableFields(Class<?> targetClazz, List<ProvidableField> providableFields) {
        for (Field field : targetClazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(Provided.class)) {
                providableFields.add(SingleElementProvidableField.from(field));
                continue;
            }
            if (!field.isAnnotationPresent(ProvidedServices.class)) continue;
            providableFields.add(ManyElementsProvidableField.from(field));
        }
    }

    @ConstructorProperties(value={"targetClazz", "fields"})
    public ProvidableClass(Class<T> targetClazz, Iterable<ProvidableField> fields) {
        this.targetClazz = targetClazz;
        this.fields = fields;
    }
}

