/*
 * Decompiled with CFR 0.152.
 */
package trip.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import trip.spi.ProducerFactory;
import trip.spi.ProviderContext;
import trip.spi.ServiceProviderException;
import trip.spi.StartupListener;
import trip.spi.helpers.EmptyProviderContext;
import trip.spi.helpers.KeyValueProviderContext;
import trip.spi.helpers.ProducerFactoryMap;
import trip.spi.helpers.ProvidableClass;
import trip.spi.helpers.SingleObjectIterable;
import trip.spi.helpers.cache.CachedIterable;
import trip.spi.helpers.cache.ServiceLoader;
import trip.spi.helpers.filter.AnyClass;
import trip.spi.helpers.filter.AnyObject;
import trip.spi.helpers.filter.Condition;
import trip.spi.helpers.filter.Filter;
import trip.spi.helpers.filter.NamedClass;
import trip.spi.helpers.filter.NamedObject;

public class ServiceProvider {
    final Map<Class<?>, ProvidableClass<?>> providableClassCache = new HashMap();
    final Map<Class<?>, Iterable<Class<?>>> implementedClasses = new HashMap();
    final Map<Class<?>, Iterable<?>> providers = this.createDefaultProvidedData();
    final ProducerFactoryMap producers;

    public ServiceProvider() {
        this.runAllStartupListeners();
        this.producers = this.loadAllProducers();
    }

    void runAllStartupListeners() {
        try {
            Iterable<StartupListener> startupListeners = this.loadAll(StartupListener.class);
            for (StartupListener listener : startupListeners) {
                listener.onStartup(this);
            }
        }
        catch (ServiceProviderException e) {
            throw new IllegalStateException(e);
        }
    }

    protected HashMap<Class<?>, Iterable<?>> createDefaultProvidedData() {
        HashMap injectables = new HashMap();
        injectables.put(this.getClass(), new SingleObjectIterable<ServiceProvider>(this));
        return injectables;
    }

    protected ProducerFactoryMap loadAllProducers() {
        try {
            return ProducerFactoryMap.from(this.loadAll(ProducerFactory.class));
        }
        catch (ServiceProviderException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T load(Class<T> interfaceClazz) throws ServiceProviderException {
        return this.load(interfaceClazz, new AnyObject());
    }

    public <T> T load(Class<T> interfaceClazz, String name) throws ServiceProviderException {
        return this.load(interfaceClazz, new NamedObject(name));
    }

    public <T> T load(Class<T> interfaceClazz, Condition<T> condition) throws ServiceProviderException {
        return this.load(interfaceClazz, condition, new EmptyProviderContext());
    }

    public <T> T load(Class<T> interfaceClazz, ProviderContext context) throws ServiceProviderException {
        return this.load(interfaceClazz, new AnyObject(), context);
    }

    public <T> T load(Class<T> interfaceClazz, Map<String, Object> contextData) throws ServiceProviderException {
        return this.load(interfaceClazz, new AnyObject(), new KeyValueProviderContext(contextData));
    }

    public <T> T load(Class<T> interfaceClazz, String name, Map<String, Object> contextData) throws ServiceProviderException {
        return this.load(interfaceClazz, new NamedObject(name), new KeyValueProviderContext(contextData));
    }

    public <T> T load(Class<T> interfaceClazz, Condition<T> condition, ProviderContext context) throws ServiceProviderException {
        T produced = this.produceFromFactory(interfaceClazz, condition, context);
        if (produced != null) {
            return produced;
        }
        return Filter.first(this.loadAll(interfaceClazz, condition), condition);
    }

    private <T> ProducerFactory<T> getProviderFor(Class<T> interfaceClazz, Condition<T> condition) {
        if (this.producers == null) {
            return null;
        }
        return this.producers.get(interfaceClazz, condition);
    }

    public <T> Iterable<T> loadAll(Class<T> interfaceClazz, String name) throws ServiceProviderException {
        return this.loadAll(interfaceClazz, new NamedObject(name));
    }

    public <T> Iterable<T> loadAll(Class<T> interfaceClazz, Condition<T> condition) throws ServiceProviderException {
        return Filter.filter(this.loadAll(interfaceClazz), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Iterable<T> loadAll(Class<T> interfaceClazz) throws ServiceProviderException {
        Iterable<Object> iterable = this.providers.get(interfaceClazz);
        if (iterable == null) {
            Map<Class<?>, Iterable<?>> map = this.providers;
            synchronized (map) {
                iterable = this.providers.get(interfaceClazz);
                if (iterable == null) {
                    iterable = this.loadAllServicesImplementingTheInterface(interfaceClazz);
                }
            }
        }
        return iterable;
    }

    protected <T> Iterable<T> loadAllServicesImplementingTheInterface(Class<T> interfaceClazz) throws ServiceProviderException {
        try {
            CachedIterable<T> iterable = this.loadServiceProvidersFor(interfaceClazz);
            this.provideOn(iterable);
            this.providerFor(interfaceClazz, iterable);
            return iterable;
        }
        catch (StackOverflowError cause) {
            throw new ServiceConfigurationError("Could not load implementations of " + interfaceClazz.getCanonicalName() + ": Recursive dependency injection detected.");
        }
    }

    protected <T> CachedIterable<T> loadServiceProvidersFor(Class<T> interfaceClazz) throws ServiceProviderException {
        Iterable<Class<T>> iterableInterfaces = this.loadClassesImplementing(interfaceClazz);
        return ServiceLoader.loadFrom(iterableInterfaces);
    }

    public <T> Class<T> loadClassImplementing(Class<T> interfaceClazz) {
        return this.loadClassImplementing(interfaceClazz, new AnyClass());
    }

    public <T> Class<T> loadClassImplementing(Class<T> interfaceClazz, String named) {
        return this.loadClassImplementing(interfaceClazz, new NamedClass(named));
    }

    public <T> Class<T> loadClassImplementing(Class<T> interfaceClazz, Condition<Class<T>> condition) {
        return Filter.first(this.loadClassesImplementing(interfaceClazz), condition);
    }

    public <T> Iterable<Class<T>> loadClassesImplementing(Class<T> interfaceClazz, Condition<Class<T>> condition) {
        return Filter.filter(this.loadClassesImplementing(interfaceClazz), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Iterable<Class<T>> loadClassesImplementing(Class<T> interfaceClazz) {
        Iterable<Class<Object>> implementations = this.implementedClasses.get(interfaceClazz);
        if (implementations == null) {
            Map<Class<?>, Iterable<Class<?>>> map = this.implementedClasses;
            synchronized (map) {
                implementations = this.implementedClasses.get(interfaceClazz);
                if (implementations == null) {
                    implementations = ServiceLoader.loadImplementationsFor(interfaceClazz);
                    this.implementedClasses.put(interfaceClazz, implementations);
                }
            }
        }
        return implementations;
    }

    public <T> void providerFor(Class<T> interfaceClazz, ProducerFactory<T> provider) {
        this.producers.memorizeProviderForClazz(provider, interfaceClazz);
    }

    public <T> void providerFor(Class<T> interfaceClazz, T object) {
        this.providerFor(interfaceClazz, new SingleObjectIterable<T>(object));
    }

    protected <T> void providerFor(Class<T> interfaceClazz, Iterable<T> iterable) {
        this.providers.put(interfaceClazz, iterable);
    }

    public <T> void provideOn(Iterable<T> iterable) throws ServiceProviderException {
        for (T object : iterable) {
            this.provideOn(object);
        }
    }

    public void provideOn(Object object) throws ServiceProviderException {
        try {
            ProvidableClass<?> providableClass = this.retrieveProvidableClass(object.getClass());
            providableClass.provide(object, this);
        }
        catch (Exception cause) {
            throw new ServiceProviderException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProvidableClass<?> retrieveProvidableClass(Class<?> targetClazz) {
        ProvidableClass<?> providableClass = this.providableClassCache.get(targetClazz);
        if (providableClass == null) {
            Map<Class<?>, ProvidableClass<?>> map = this.providableClassCache;
            synchronized (map) {
                providableClass = this.providableClassCache.get(targetClazz);
                if (providableClass == null) {
                    providableClass = ProvidableClass.wrap(targetClazz);
                    this.providableClassCache.put(targetClazz, providableClass);
                }
            }
        }
        return providableClass;
    }

    private <T> T produceFromFactory(Class<T> interfaceClazz, Condition<T> condition, ProviderContext context) throws ServiceProviderException {
        ProducerFactory<T> provider = this.getProviderFor(interfaceClazz, condition);
        if (provider != null) {
            return provider.provide(context);
        }
        return null;
    }
}

