/*
 * Decompiled with CFR 0.152.
 */
package blah.concurrency.second;

import blah.concurrency.second.Cursor;
import blah.concurrency.second.Job;
import blah.concurrency.second.Locker;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class JobQueue {
    final Locker emptySlotsLocker = new Locker();
    final Locker fullSlotsLocker = new Locker();
    final AtomicReference<Job>[] jobs;
    final Cursor readCursor;
    final Cursor writeCursor;
    final int bufferSize;
    volatile int wroteData = 0;

    public JobQueue(int bufferSize) {
        this.jobs = new AtomicReference[bufferSize];
        this.readCursor = new Cursor(bufferSize);
        this.writeCursor = new Cursor(bufferSize);
        this.bufferSize = bufferSize;
        this.preAllocateBuffer();
    }

    void preAllocateBuffer() {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.jobs[i] = new AtomicReference();
        }
    }

    public void put(Job job) throws InterruptedException {
        int writablePosition = this.writeCursor.next();
        AtomicReference<Job> reference = this.jobs[writablePosition];
        while (!reference.compareAndSet(null, job)) {
            LockSupport.parkNanos(reference, 1L);
        }
        ++this.wroteData;
    }

    int waitUntilHaveWritableSlots() {
        return this.writeCursor.next();
    }

    boolean haveWritableSlots() {
        return this.wroteData <= this.bufferSize;
    }

    public Job get() throws InterruptedException {
        AtomicReference<Job> readableSlot = this.waitUntilHaveReadableSlots();
        Job job = readableSlot.getAndSet(null);
        --this.wroteData;
        return job;
    }

    AtomicReference<Job> waitUntilHaveReadableSlots() {
        AtomicReference<Job> reference = this.jobs[this.readCursor.next()];
        while (reference.get() == null) {
            LockSupport.parkNanos(reference, 1L);
        }
        return reference;
    }

    boolean haveReadbleData() {
        return this.wroteData > 0;
    }
}

