/*
 * Decompiled with CFR 0.152.
 */
package blah.concurrency.second;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class FieldReference {
    static final Unsafe unsafe = FieldReference.getUnsafe();
    final Object target;
    final long fieldAddress;

    public static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static FieldReference wrap(Object object, String fieldName) {
        long fieldAddress = FieldReference.getFieldAddress(object.getClass(), fieldName);
        return new FieldReference(object, fieldAddress);
    }

    public static long getFieldAddress(Class<?> clazz, String fieldName) {
        try {
            return unsafe.objectFieldOffset(clazz.getDeclaredField(fieldName));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public final boolean compareAndSet(int expect, int update) {
        return unsafe.compareAndSwapInt(this.target, this.fieldAddress, expect, update);
    }

    public final <T> boolean compareAndSet(T expect, T update) {
        return unsafe.compareAndSwapObject(this.target, this.fieldAddress, expect, update);
    }

    @ConstructorProperties(value={"target", "fieldAddress"})
    public FieldReference(Object target, long fieldAddress) {
        this.target = target;
        this.fieldAddress = fieldAddress;
    }
}

