/*
 * Decompiled with CFR 0.152.
 */
package blah.concurrency.second;

import blah.concurrency.second.Job;
import blah.concurrency.second.JobDispatcher;
import blah.concurrency.second.JobQueue;
import blah.concurrency.second.JobRunner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultJobDispatcher
implements JobDispatcher {
    final int availableProcessors = Runtime.getRuntime().availableProcessors();
    final ExecutorService executor;
    final JobQueue buffer;

    public DefaultJobDispatcher(int bufferSize) {
        this.buffer = new JobQueue(bufferSize);
        this.executor = Executors.newFixedThreadPool(this.availableProcessors);
        this.initializeJobRunners();
    }

    void initializeJobRunners() {
        for (int i = 0; i < this.availableProcessors; ++i) {
            this.executor.submit(new JobRunner(this.buffer, this));
        }
    }

    @Override
    public void submit(Job job) throws InterruptedException {
        this.buffer.put(job);
    }
}

