/*
 * Decompiled with CFR 0.152.
 */
package blah.concurrency.first;

import blah.concurrency.first.Consumer;
import java.beans.ConstructorProperties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Producer {
    final ExecutorService executor = Executors.newCachedThreadPool();
    final BlockingQueue<Number> data = new LinkedBlockingQueue<Number>();
    final CountDownLatch counter;

    public Consumer createConsumer() {
        Consumer consumer = new Consumer(this.data, this.counter);
        this.executor.submit(consumer);
        return consumer;
    }

    public void createConsumers(int amountOfConsumers) {
        for (int i = 0; i < amountOfConsumers; ++i) {
            this.createConsumer();
        }
    }

    public void produce() {
        this.data.add(1);
    }

    public void stop() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    @ConstructorProperties(value={"counter"})
    public Producer(CountDownLatch counter) {
        this.counter = counter;
    }
}

