/*
 * Decompiled with CFR 0.152.
 */
package stalkr.http;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stalkr.http.CompletionListener;
import stalkr.http.ContextualRequests;

public class AsyncCompletionHandlerBase
extends AsyncCompletionHandler<Response> {
    private static final Logger log = LoggerFactory.getLogger(AsyncCompletionHandlerBase.class);
    final ContextualRequests requests;
    final CompletionListener<Response> listener;

    public Response onCompleted(Response response) throws Exception {
        this.onComplete(response);
        return response;
    }

    public void onThrowable(Throwable t) {
        log.warn(t.getMessage(), t);
        this.onComplete(null);
    }

    private void onComplete(Response response) {
        try {
            this.listener.onComplete(this.requests, response);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    @ConstructorProperties(value={"requests", "listener"})
    public AsyncCompletionHandlerBase(ContextualRequests requests, CompletionListener<Response> listener) {
        this.requests = requests;
        this.listener = listener;
    }
}

