/*
 * Decompiled with CFR 0.152.
 */
package stalkr.http;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import stalkr.http.ContextualRequests;
import stalkr.http.CookieStoredContext;
import stalkr.http.ListenableRequestBuilder;
import stalkr.http.Requests;
import stalkr.http.StoredContext;

@Singleton
public class DefaultRequestFactory
extends Requests {
    final AsyncHttpClient client = this.configureClient();
    final StoredContext storedContext = null;
    final ExecutorService executor = Executors.newCachedThreadPool();

    AsyncHttpClient configureClient() {
        AsyncHttpClientConfig config = this.createHttpClientConfig();
        return new AsyncHttpClient(config);
    }

    AsyncHttpClientConfig createHttpClientConfig() {
        return new AsyncHttpClientConfig.Builder().setCompressionEnabled(true).setAllowPoolingConnection(true).setExecutorService(this.executor).setRequestTimeoutInMs(30000).build();
    }

    @Override
    protected ListenableRequestBuilder builder() {
        ContextualRequests requests = new ContextualRequests(this.client, this.executor, new CookieStoredContext());
        return new ListenableRequestBuilder(requests);
    }

    public AsyncHttpClient client() {
        return this.client;
    }

    @Override
    public StoredContext storedContext() {
        return this.storedContext;
    }

    public ExecutorService executor() {
        return this.executor;
    }
}

