/*
 * Decompiled with CFR 0.152.
 */
package stalkr.http;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stalkr.http.ListenableRequestBuilder;
import stalkr.http.StoredContext;

public class CookieStoredContext
implements StoredContext {
    final List<Cookie> cookies = new ArrayList<Cookie>();
    final Map<String, Object> attachments = new HashMap<String, Object>();

    @Override
    public void store(HttpResponseHeaders headers) {
        FluentCaseInsensitiveStringsMap fluentHeaders = headers.getHeaders();
        List foundCookies = fluentHeaders.get((Object)"Set-Cookie");
        if (foundCookies != null) {
            for (String cookie : foundCookies) {
                this.cookies.add(CookieDecoder.decode((String)cookie));
            }
        }
    }

    @Override
    public void apply(ListenableRequestBuilder builder) {
        for (Cookie cookie : this.cookies) {
            builder.addOrReplaceCookie(cookie);
        }
    }

    @Override
    public void attach(String key, Object value) {
        this.attachments.put(key, value);
    }

    @Override
    public Object getAttachedObject(String key) {
        return this.attachments.get(key);
    }

    @Override
    public String getCookie(String key) {
        for (Cookie cookie : this.cookies) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return null;
    }
}

