/*
 * Decompiled with CFR 0.152.
 */
package stalkr.captcha.dbc;

import com.deathbycaptcha.Captcha;
import com.deathbycaptcha.Client;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import stalkr.captcha.dbc.SolverCallback;
import stalkr.commons.Name;
import stalkr.crawler.ErrorHandler;
import trip.spi.Provided;
import trip.spi.Stateless;

@Stateless
public class DeadByCaptchaSolver {
    @Provided
    Client client;
    @Provided
    @Name(value="captcha-client-thread-pool")
    ExecutorService executor;
    @Provided
    ErrorHandler errorHandler;

    public void solve(byte[] inputStream, SolverCallback callback) {
        this.solve(inputStream, callback, this.errorHandler);
    }

    public void solve(byte[] inputStream, SolverCallback callback, ErrorHandler errorHandler) {
        AsyncCaptchaRunner runner = new AsyncCaptchaRunner(inputStream, callback, errorHandler);
        this.executor.execute(runner);
    }

    class AsyncCaptchaRunner
    implements Runnable {
        final byte[] inputStream;
        final SolverCallback callback;
        final ErrorHandler errorHandler;

        @Override
        public void run() {
            try {
                Captcha decode = DeadByCaptchaSolver.this.client.decode(this.inputStream);
                this.callback.run(decode.text);
            }
            catch (Exception e) {
                this.errorHandler.handle((Throwable)e);
            }
        }

        @ConstructorProperties(value={"inputStream", "callback", "errorHandler"})
        public AsyncCaptchaRunner(byte[] inputStream, SolverCallback callback, ErrorHandler errorHandler) {
            this.inputStream = inputStream;
            this.callback = callback;
            this.errorHandler = errorHandler;
        }
    }
}

