/*
 * Decompiled with CFR 0.152.
 */
package com.deathbycaptcha;

import com.deathbycaptcha.AccessDeniedException;
import com.deathbycaptcha.Captcha;
import com.deathbycaptcha.Client;
import com.deathbycaptcha.Exception;
import com.deathbycaptcha.InvalidCaptchaException;
import com.deathbycaptcha.ServiceOverloadException;
import com.deathbycaptcha.User;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Random;
import org.base64.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketClient
extends Client {
    public static final String HOST = "api.dbcapi.me";
    public static final int FIRST_PORT = 8123;
    public static final int LAST_PORT = 8130;
    public static final String TERMINATOR = "\r\n";
    protected SocketChannel channel = null;
    protected Object callLock = new Object();

    /*
     * Unable to fully structure code
     */
    protected String sendAndReceive(byte[] payload) throws IOException {
        sbuf = ByteBuffer.wrap(payload);
        rbuf = ByteBuffer.allocateDirect(256);
        rbufDecoder = Charset.forName("UTF-8").newDecoder();
        response = new StringBuilder();
        ops = 5;
        if (this.channel.isConnectionPending()) {
            ops |= 8;
        }
        selector = Selector.open();
        try {
            this.channel.register(selector, ops);
            block6: while (true) {
                if (0 >= selector.select(5000L)) {
                    continue;
                }
                keys = selector.selectedKeys().iterator();
                while (true) {
                    if (keys.hasNext()) ** break;
                    continue block6;
                    key = keys.next();
                    ch = (SocketChannel)key.channel();
                    if (key.isConnectable()) {
                        ch.finishConnect();
                    }
                    if (!key.isReadable() || sbuf.hasRemaining()) ** GOTO lbl38
                    while (0 < ch.read(rbuf)) {
                        rbuf.flip();
                        response.append(rbufDecoder.decode(rbuf).toString());
                    }
                    if (2 <= response.length() && response.substring(response.length() - 2, response.length()).equals("\r\n")) {
                        response.setLength(response.length() - 2);
                        var11_12 = response.toString();
                        return var11_12;
                    }
                    if (0 == response.length()) {
                        throw new IOException("Connection lost");
                    }
lbl38:
                    // 3 sources

                    if (key.isWritable() && sbuf.hasRemaining()) {
                        while (0 < ch.write(sbuf) && sbuf.hasRemaining()) {
                        }
                    }
                    keys.remove();
                    continue;
                    break;
                }
                break;
            }
            catch (java.lang.Exception e) {
                throw new IOException("API communication failed: " + e.toString());
            }
        }
        finally {
            selector.close();
        }
    }

    @Override
    public void close() {
        if (null != this.channel) {
            this.log("CLOSE");
            if (this.channel.isConnected() || this.channel.isConnectionPending()) {
                try {
                    this.channel.socket().shutdownOutput();
                    this.channel.socket().shutdownInput();
                }
                catch (java.lang.Exception e) {
                }
                finally {
                    try {
                        this.channel.close();
                    }
                    catch (java.lang.Exception e) {}
                }
            }
            try {
                this.channel.socket().close();
            }
            catch (java.lang.Exception exception) {
                // empty catch block
            }
            this.channel = null;
        }
    }

    @Override
    public boolean connect() throws IOException {
        if (null == this.channel) {
            this.log("OPEN");
            InetAddress host = null;
            try {
                host = InetAddress.getByName(HOST);
            }
            catch (java.lang.Exception e) {
                throw new IOException("API host not found");
            }
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            try {
                channel.connect(new InetSocketAddress(host, 8123 + new Random().nextInt(8)));
            }
            catch (IOException e) {
                throw new IOException("API connection failed");
            }
            this.channel = channel;
        }
        return null != this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject call(String cmd, JSONObject args) throws IOException, Exception {
        try {
            args.put("cmd", cmd).put("version", "DBC/Java v4.1.0");
        }
        catch (JSONException e) {
            return new JSONObject();
        }
        int attempts = 2;
        byte[] payload = (args.toString() + TERMINATOR).getBytes();
        JSONObject response = null;
        while (0 < attempts && null == response) {
            --attempts;
            if (null == this.channel && !cmd.equals("login")) {
                this.call("login", this.getCredentials());
            }
            Object object = this.callLock;
            synchronized (object) {
                if (this.connect()) {
                    this.log("SEND", args.toString());
                    try {
                        response = new JSONObject(this.sendAndReceive(payload));
                    }
                    catch (java.lang.Exception e) {
                        this.close();
                    }
                }
            }
        }
        if (null == response) {
            throw new IOException("API connection lost or timed out");
        }
        this.log("RECV", response.toString());
        String error = response.optString("error", null);
        if (null != error) {
            Object object = this.callLock;
            synchronized (object) {
                this.close();
            }
            if (error.equals("not-logged-in")) {
                throw new AccessDeniedException("Access denied, check your credentials");
            }
            if (error.equals("banned")) {
                throw new AccessDeniedException("Access denied, account is suspended");
            }
            if (error.equals("insufficient-funds")) {
                throw new AccessDeniedException("Access denied, balance is too low");
            }
            if (error.equals("invalid-captcha")) {
                throw new InvalidCaptchaException("CAPTCHA was rejected by the service, check if it's a valid image");
            }
            if (error.equals("service-overload")) {
                throw new ServiceOverloadException("CAPTCHA was rejected due to service overload, try again later");
            }
            throw new IOException("API server error occured: " + error);
        }
        return response;
    }

    protected JSONObject call(String cmd) throws IOException, Exception {
        return this.call(cmd, new JSONObject());
    }

    public SocketClient(String username, String password) {
        super(username, password);
    }

    public void finalize() {
        this.close();
    }

    @Override
    public User getUser() throws IOException, Exception {
        return new User(this.call("user"));
    }

    @Override
    public Captcha upload(byte[] img) throws IOException, Exception {
        JSONObject args = new JSONObject();
        try {
            args.put("captcha", Base64.encodeBytes(img)).put("swid", 0);
        }
        catch (JSONException e) {
            // empty catch block
        }
        Captcha c = new Captcha(this.call("upload", args));
        return c.isUploaded() ? c : null;
    }

    @Override
    public Captcha getCaptcha(int id) throws IOException, Exception {
        JSONObject args = new JSONObject();
        try {
            args.put("captcha", id);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new Captcha(this.call("captcha", args));
    }

    @Override
    public boolean report(int id) throws IOException, Exception {
        JSONObject args = new JSONObject();
        try {
            args.put("captcha", id);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return !new Captcha(this.call("report", args)).isCorrect();
    }
}

