/*
 * Decompiled with CFR 0.152.
 */
package com.deathbycaptcha;

import com.deathbycaptcha.Captcha;
import com.deathbycaptcha.Exception;
import com.deathbycaptcha.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Client {
    public static final String API_VERSION = "DBC/Java v4.1.0";
    public static final int SOFTWARE_VENDOR_ID = 0;
    public static final int DEFAULT_TIMEOUT = 60;
    public static final int POLLS_INTERVAL = 5;
    public boolean isVerbose = false;
    protected String _username = "";
    protected String _password = "";

    protected void log(String call, String msg) {
        if (this.isVerbose) {
            System.out.println(System.currentTimeMillis() / 1000L + " " + call + (null != msg ? ": " + msg : ""));
        }
    }

    protected void log(String call) {
        this.log(call, null);
    }

    protected JSONObject getCredentials() {
        try {
            return new JSONObject().put("username", this._username).put("password", this._password);
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    protected byte[] load(InputStream st) throws IOException {
        int n = 0;
        int offset = 0;
        byte[] img = new byte[]{};
        while (true) {
            try {
                n = st.available();
            }
            catch (IOException e) {
                n = 0;
            }
            if (0 >= n) break;
            if (offset + n > img.length) {
                img = Arrays.copyOf(img, img.length + n);
            }
            offset += st.read(img, offset, n);
        }
        return img;
    }

    protected byte[] load(File f) throws IOException, FileNotFoundException {
        try (FileInputStream st = new FileInputStream(f);){
            byte[] byArray = this.load(st);
            return byArray;
        }
    }

    protected byte[] load(String fn) throws IOException, FileNotFoundException {
        return this.load(new File(fn));
    }

    public abstract void close();

    public abstract boolean connect() throws IOException;

    public Client(String username, String password) {
        this._username = username;
        this._password = password;
    }

    public abstract User getUser() throws IOException, Exception;

    public double getBalance() throws IOException, Exception {
        return this.getUser().balance;
    }

    public abstract Captcha upload(byte[] var1) throws IOException, Exception;

    public Captcha upload(InputStream st) throws IOException, Exception {
        return this.upload(this.load(st));
    }

    public Captcha upload(File f) throws IOException, FileNotFoundException, Exception {
        return this.upload(this.load(f));
    }

    public Captcha upload(String fn) throws IOException, FileNotFoundException, Exception {
        return this.upload(this.load(fn));
    }

    public abstract Captcha getCaptcha(int var1) throws IOException, Exception;

    public Captcha getCaptcha(Captcha captcha) throws IOException, Exception {
        return this.getCaptcha(captcha.id);
    }

    public String getText(int id) throws IOException, Exception {
        return this.getCaptcha((int)id).text;
    }

    public String getText(Captcha captcha) throws IOException, Exception {
        return this.getText(captcha.id);
    }

    public abstract boolean report(int var1) throws IOException, Exception;

    public boolean report(Captcha captcha) throws IOException, Exception {
        return this.report(captcha.id);
    }

    public Captcha decode(byte[] img, int timeout) throws IOException, Exception, InterruptedException {
        long deadline = System.currentTimeMillis() + (long)((0 < timeout ? timeout : 60) * 1000);
        Captcha captcha = this.upload(img);
        if (null != captcha) {
            while (deadline > System.currentTimeMillis() && !captcha.isSolved()) {
                Thread.sleep(5000L);
                captcha = this.getCaptcha(captcha.id);
            }
            if (captcha.isSolved() && captcha.isCorrect()) {
                return captcha;
            }
        }
        return null;
    }

    public Captcha decode(byte[] img) throws IOException, Exception, InterruptedException {
        return this.decode(img, 0);
    }

    public Captcha decode(InputStream st, int timeout) throws IOException, Exception, InterruptedException {
        return this.decode(this.load(st), timeout);
    }

    public Captcha decode(InputStream st) throws IOException, Exception, InterruptedException {
        return this.decode(st, 0);
    }

    public Captcha decode(File f, int timeout) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(this.load(f), timeout);
    }

    public Captcha decode(File f) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(f, 0);
    }

    public Captcha decode(String fn, int timeout) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(this.load(fn), timeout);
    }

    public Captcha decode(String fn) throws IOException, FileNotFoundException, Exception, InterruptedException {
        return this.decode(fn, 0);
    }
}

