/*
 * Decompiled with CFR 0.152.
 */
package stalkr.commons;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import stalkr.commons.Name;
import trip.spi.Producer;
import trip.spi.ProviderContext;
import trip.spi.Singleton;

@Singleton
public class ExecutorServiceProducer {
    final Map<String, ExecutorService> executors = new HashMap<String, ExecutorService>();

    @Producer
    public ExecutorService produceExecutorService(ProviderContext context) {
        String name = this.retrieveNameFrom(context);
        ExecutorService executor = this.retrieveOrCreateExecutorForName(name);
        return executor;
    }

    String retrieveNameFrom(ProviderContext context) {
        Name name = (Name)context.getAnnotation(Name.class);
        if (name != null) {
            return name.value();
        }
        throw new IllegalStateException("Nothing produced: no name provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService retrieveOrCreateExecutorForName(String name) {
        ExecutorService executor = this.executors.get(name);
        if (executor == null) {
            Map<String, ExecutorService> map = this.executors;
            synchronized (map) {
                executor = this.executors.get(name);
                if (executor == null) {
                    executor = this.createExecutorService(name);
                    this.executors.put(name, executor);
                }
            }
        }
        return executor;
    }

    ExecutorService createExecutorService(String name) {
        return Executors.newCachedThreadPool();
    }
}

