/*
 * Decompiled with CFR 0.152.
 */
package stalkr.html.parser;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import stalkr.html.parser.BindableClass;
import stalkr.html.parser.Setter;

public class EmbeddedElementSetter
implements Setter {
    final String selector;
    final Field field;
    final BindableClass modelClass;

    @Override
    public void bind(Element document, Object instance) {
        try {
            Elements elements = document.select(this.selector);
            if (elements.isEmpty()) {
                throw new RuntimeException("No element found for selector: " + this.selector);
            }
            Object object = this.createNewBinddedDataFromModelClass(elements.first());
            this.field.set(instance, object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    Object createNewBinddedDataFromModelClass(Element element) {
        Object newInstance = this.modelClass.newInstanceOf();
        this.modelClass.bind(element, newInstance);
        return newInstance;
    }

    @ConstructorProperties(value={"selector", "field", "modelClass"})
    public EmbeddedElementSetter(String selector, Field field, BindableClass modelClass) {
        this.selector = selector;
        this.field = field;
        this.modelClass = modelClass;
    }
}

