/*
 * Decompiled with CFR 0.152.
 */
package stalkr.html.parser;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.function.BiFunction;
import org.jsoup.nodes.Element;
import stalkr.html.parser.Setter;

public class AttributeElementSetter
implements Setter {
    final Field field;
    final String selector;
    final String attribute;
    final BiFunction<String, Boolean, Object> valueParser;
    final boolean isNonnull;

    @Override
    public void bind(Element document, Object instance) {
        Element element = document.select(this.selector).first();
        if (element == null) {
            if (!this.isNonnull) {
                return;
            }
            throw new RuntimeException("Can't find element with selector [" + this.selector + "]");
        }
        String value = element.attr(this.attribute);
        String string = value = value == null ? null : value.trim();
        if (value == null || value.isEmpty()) {
            if (!this.isNonnull) {
                return;
            }
            throw new RuntimeException("Value of attribute [" + this.attribute + "] on element [" + this.selector + "] is null");
        }
        this.set(this.field, instance, this.valueParser.apply(value, this.isNonnull));
    }

    @ConstructorProperties(value={"field", "selector", "attribute", "valueParser", "isNonnull"})
    public AttributeElementSetter(Field field, String selector, String attribute, BiFunction<String, Boolean, Object> valueParser, boolean isNonnull) {
        this.field = field;
        this.selector = selector;
        this.attribute = attribute;
        this.valueParser = valueParser;
        this.isNonnull = isNonnull;
    }
}

