/*
 * Decompiled with CFR 0.152.
 */
package stalkr.html;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.inject.Singleton;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import stalkr.html.parser.BindableClass;
import stalkr.html.parser.BindableClassFactory;

@Singleton
public class HtmlBinder {
    final BindableClassFactory factory;

    public HtmlBinder() {
        this(new BindableClassFactory.Builder().build());
    }

    public <T> T bind(String data, Class<T> type) {
        Document document = Jsoup.parse((String)data);
        BindableClass bindableClass = this.factory.getBindableClassFor(type);
        return this.newBindedDataFrom(bindableClass, (Element)document);
    }

    public <T> List<T> bind(String data, Class<T> type, String selector) {
        Elements elements = Jsoup.parse((String)data).select(selector);
        BindableClass bindableClass = this.factory.getBindableClassFor(type);
        ArrayList<T> list = new ArrayList<T>();
        for (Element element : elements) {
            list.add(this.newBindedDataFrom(bindableClass, element));
        }
        return list;
    }

    <T> T newBindedDataFrom(BindableClass bindableClass, Element element) {
        Object instance = bindableClass.newInstanceOf();
        bindableClass.bind(element, instance);
        return (T)instance;
    }

    public List<String> select(String data, String selector) {
        ArrayList<String> list = new ArrayList<String>();
        this.selectElements(data, selector, element -> list.add(element.text()));
        return list;
    }

    public List<String> selectAttr(String data, String selector, String attr) {
        ArrayList<String> list = new ArrayList<String>();
        this.selectElements(data, selector, element -> list.add(element.attr(attr)));
        return list;
    }

    public void selectElements(String data, String selector, Consumer<Element> consumer) {
        Document document = Jsoup.parse((String)data);
        Elements elements = document.select(selector);
        for (Element element : elements) {
            consumer.accept(element);
        }
    }

    @ConstructorProperties(value={"factory"})
    public HtmlBinder(BindableClassFactory factory) {
        this.factory = factory;
    }

    public static class Builder {
        private BindableClassFactory.Builder factoryBuilder = new BindableClassFactory.Builder();

        public Builder parser(Class<?> type, BiFunction<String, Boolean, Object> parser) {
            this.factoryBuilder.parser(type, parser);
            return this;
        }

        public Builder datePattern(String pattern) {
            this.factoryBuilder.datePattern(pattern);
            return this;
        }

        public Builder timePattern(String pattern) {
            this.factoryBuilder.timePattern(pattern);
            return this;
        }

        public HtmlBinder build() {
            return new HtmlBinder(this.factoryBuilder.build());
        }
    }
}

