/*
 * Decompiled with CFR 0.152.
 */
package stalkr.html.parser;

import java.lang.reflect.Field;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import stalkr.html.BindableAttribute;
import stalkr.html.BindableAttributes;
import stalkr.html.BindableEmbedded;
import stalkr.html.BindableManyTimes;
import stalkr.html.BindableText;
import stalkr.html.BindableTextSearch;
import stalkr.html.BindableTexts;
import stalkr.html.DatePattern;
import stalkr.html.parser.AttributeElementSetter;
import stalkr.html.parser.BindableClass;
import stalkr.html.parser.EmbeddedElementSetter;
import stalkr.html.parser.FieldParser;
import stalkr.html.parser.RepeatableElementSetter;
import stalkr.html.parser.SearchTextValueParser;
import stalkr.html.parser.Setter;
import stalkr.html.parser.TextElementSetter;
import stalkr.html.parser.ValueParser;
import stalkr.html.parser.WrappedListOfElementSetter;

@Singleton
public class BindableClassFactory {
    final Map<Class<?>, BindableClass> cache = new ConcurrentHashMap();
    final List<FieldParser<?>> fieldParsers = Arrays.asList(this.bindableTexts(), this.bindableText(), this.bindableAttributes(), this.bindableAttribute(), this.bindableManyTimes(), this.bindableEmbedded());
    final Map<Class<?>, ValueParser> parsers = this.createValueParsers();
    final ValueParser defaultDateParser = this.dateParser("dd/MM/yyyy");
    final ValueParser defaultTimeParser = this.timeParser("HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BindableClass getBindableClassFor(Class<T> type) {
        BindableClass bindableData = this.cache.get(type);
        if (bindableData == null) {
            Map<Class<?>, BindableClass> map = this.cache;
            synchronized (map) {
                bindableData = this.cache.get(type);
                if (bindableData == null) {
                    bindableData = this.createNewBindableClass(type);
                    this.cache.put(type, bindableData);
                }
            }
        }
        return bindableData;
    }

    BindableClass createNewBindableClass(Class<?> clazz) {
        List<Setter> fields = this.stripBindableFieldsOfClazz(clazz);
        return new BindableClass(clazz, fields);
    }

    List<Setter> stripBindableFieldsOfClazz(Class<?> clazz) {
        ArrayList<Setter> list = new ArrayList<Setter>();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                this.memorizeBindableField(list, field);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public void memorizeBindableField(List<Setter> list, Field field) {
        int originalSize = list.size();
        Iterator<FieldParser<?>> listIterator = this.fieldParsers.iterator();
        while (listIterator.hasNext() && list.size() <= originalSize) {
            listIterator.next().parse(list, field);
        }
    }

    FieldParser<BindableText> bindableText() {
        return FieldParser.of(BindableText.class, (field, annotation) -> new TextElementSetter(field, annotation.value(), this.valueParseFor(field)));
    }

    FieldParser<BindableTexts> bindableTexts() {
        return FieldParser.of(BindableTexts.class, (field, annotation) -> {
            WrappedListOfElementSetter setters = new WrappedListOfElementSetter();
            for (BindableText bindableText : annotation.value()) {
                setters.wrap(new TextElementSetter(field, bindableText.value(), this.valueParseFor(field)));
            }
            return setters;
        });
    }

    FieldParser<BindableAttribute> bindableAttribute() {
        return FieldParser.of(BindableAttribute.class, (field, annotation) -> new AttributeElementSetter(field, annotation.selector(), annotation.attribute(), this.valueParseFor(field)));
    }

    FieldParser<BindableAttributes> bindableAttributes() {
        return FieldParser.of(BindableAttributes.class, (field, annotation) -> {
            WrappedListOfElementSetter setters = new WrappedListOfElementSetter();
            for (BindableAttribute attribute : annotation.value()) {
                setters.wrap(new AttributeElementSetter(field, attribute.selector(), attribute.attribute(), this.valueParseFor(field)));
            }
            return setters;
        });
    }

    FieldParser<BindableManyTimes> bindableManyTimes() {
        return FieldParser.of(BindableManyTimes.class, (field, annotation) -> {
            BindableClass bindableClass = this.getBindableClassFor(annotation.model());
            return new RepeatableElementSetter(annotation.selector(), field, bindableClass);
        });
    }

    FieldParser<BindableEmbedded> bindableEmbedded() {
        return FieldParser.of(BindableEmbedded.class, (field, annotation) -> {
            BindableClass bindableClass = this.getBindableClassFor(field.getType());
            return new EmbeddedElementSetter(annotation.value(), field, bindableClass);
        });
    }

    ValueParser valueParseFor(Field field) {
        ValueParser valueParser = this.valueParseForField(field);
        BindableTextSearch textSearch = field.getAnnotation(BindableTextSearch.class);
        if (textSearch != null) {
            Pattern pattern = Pattern.compile(textSearch.value());
            return new SearchTextValueParser(pattern, textSearch.group(), valueParser);
        }
        return valueParser;
    }

    ValueParser valueParseForField(Field field) {
        ValueParser parser = this.parsers.get(field.getType());
        if (parser != null) {
            return parser;
        }
        ValueParser dateParser = this.dateOrTimeParser(field);
        if (dateParser != null) {
            return dateParser;
        }
        throw new RuntimeException("No parser found for field " + field.getName() + " - " + field.getType());
    }

    ValueParser dateOrTimeParser(Field field) {
        DatePattern datePatternAnnotation = field.getAnnotation(DatePattern.class);
        if (Time.class.isAssignableFrom(field.getType())) {
            if (datePatternAnnotation != null) {
                return this.timeParser(datePatternAnnotation.value());
            }
            return this.defaultTimeParser;
        }
        if (Date.class.isAssignableFrom(field.getType())) {
            if (datePatternAnnotation != null) {
                return this.dateParser(datePatternAnnotation.value());
            }
            return this.defaultDateParser;
        }
        return null;
    }

    ValueParser dateParser(String datePattern) {
        return text -> {
            try {
                return new SimpleDateFormat(datePattern).parse(text);
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse date from text [" + text + "]");
            }
        };
    }

    ValueParser timeParser(String datePattern) {
        return text -> {
            try {
                return new Time(new SimpleDateFormat(datePattern).parse(text).getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse date from text [" + text + "]");
            }
        };
    }

    Map<Class<?>, ValueParser> createValueParsers() {
        HashMap map = new HashMap();
        map.put(String.class, text -> text);
        map.put(Integer.class, text -> Integer.parseInt(text));
        map.put(Long.class, text -> Long.parseLong(text));
        map.put(Double.class, text -> Double.parseDouble(text));
        map.put(Float.class, text -> Float.valueOf(Float.parseFloat(text)));
        return map;
    }
}

