/*
 * Decompiled with CFR 0.152.
 */
package stalkr.html.parser;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import stalkr.html.BindableAttribute;
import stalkr.html.BindableAttributes;
import stalkr.html.BindableManyTimes;
import stalkr.html.BindableText;
import stalkr.html.BindableTexts;
import stalkr.html.parser.AttributeElementSetter;
import stalkr.html.parser.BindableClass;
import stalkr.html.parser.FieldParser;
import stalkr.html.parser.RepeatableElementSetter;
import stalkr.html.parser.Setter;
import stalkr.html.parser.TextElementSetter;
import stalkr.html.parser.WrappedListOfElementSetter;
import trip.spi.Singleton;

@Singleton
public class BindableClassFactory {
    final Map<Class<?>, BindableClass> cache = new ConcurrentHashMap();
    final List<FieldParser<?>> fieldParsers = Arrays.asList(this.bindableTexts(), this.bindableText(), this.bindableAttributes(), this.bindableAttribute(), this.bindableManyTimes());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BindableClass getBindableClassFor(Class<T> type) {
        BindableClass bindableData = this.cache.get(type);
        if (bindableData == null) {
            Map<Class<?>, BindableClass> map = this.cache;
            synchronized (map) {
                bindableData = this.cache.get(type);
                if (bindableData == null) {
                    bindableData = this.createNewBindableClass(type);
                    this.cache.put(type, bindableData);
                }
            }
        }
        return bindableData;
    }

    BindableClass createNewBindableClass(Class<?> clazz) {
        List<Setter> fields = this.stripBindableFieldsOfClazz(clazz);
        return new BindableClass(clazz, fields);
    }

    List<Setter> stripBindableFieldsOfClazz(Class<?> clazz) {
        ArrayList<Setter> list = new ArrayList<Setter>();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                this.memorizeBindableField(list, field);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public void memorizeBindableField(List<Setter> list, Field field) {
        int originalSize = list.size();
        Iterator<FieldParser<?>> listIterator = this.fieldParsers.iterator();
        while (listIterator.hasNext() && list.size() <= originalSize) {
            listIterator.next().parse(list, field);
        }
    }

    FieldParser<BindableText> bindableText() {
        return FieldParser.of(BindableText.class, (field, annotation) -> new TextElementSetter(field, annotation.value()));
    }

    FieldParser<BindableTexts> bindableTexts() {
        return FieldParser.of(BindableTexts.class, (field, annotation) -> {
            WrappedListOfElementSetter setters = new WrappedListOfElementSetter();
            for (BindableText bindableText : annotation.value()) {
                setters.wrap(new TextElementSetter(field, bindableText.value()));
            }
            return setters;
        });
    }

    FieldParser<BindableAttribute> bindableAttribute() {
        return FieldParser.of(BindableAttribute.class, (field, annotation) -> new AttributeElementSetter(field, annotation.selector(), annotation.attribute()));
    }

    FieldParser<BindableAttributes> bindableAttributes() {
        return FieldParser.of(BindableAttributes.class, (field, annotation) -> {
            WrappedListOfElementSetter setters = new WrappedListOfElementSetter();
            for (BindableAttribute attribute : annotation.value()) {
                setters.wrap(new AttributeElementSetter(field, attribute.selector(), attribute.attribute()));
            }
            return setters;
        });
    }

    FieldParser<BindableManyTimes> bindableManyTimes() {
        return FieldParser.of(BindableManyTimes.class, (field, annotation) -> {
            BindableClass bindableClass = this.getBindableClassFor(annotation.model());
            return new RepeatableElementSetter(annotation.selector(), field, bindableClass);
        });
    }
}

