package stalkr.html;

import java.lang.reflect.Field;

import lombok.RequiredArgsConstructor;
import lombok.val;

import org.jsoup.nodes.Element;

@RequiredArgsConstructor
class TextElementSetter implements Setter {

	final Field field;
	final String[] selectors;

	@Override
	public void bind( final Element document, final Object instance ) {
		try {
			for ( val selector : selectors ) {
				val selected = document.select( selector ).first();
				if ( selected != null ) {
					field.set( instance, selected.text() );
					return;
				}
			}
		} catch ( IllegalArgumentException | IllegalAccessException e ) {
			throw new RuntimeException( e );
		}
	}
}