package stalkr.html;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.val;

import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@RequiredArgsConstructor
public class RepeatableElementSetter implements Setter {

	final String[] selectors;
	final Field field;
	final BindableClass modelClass;

	@Override
	public void bind( final Element document, final Object instance ) {
		try {
			for ( val selector : selectors ) {
				val elements = document.select( selector );
				if ( !elements.isEmpty() ) {
					setValueFromElements( instance, elements );
					return;
				}
			}
		} catch ( IllegalArgumentException | IllegalAccessException e ) {
			throw new RuntimeException( e );
		}
	}

	void setValueFromElements( final Object instance, final Elements elements ) throws IllegalAccessException {
		final List<Object> list = new ArrayList<Object>();
		for ( final Element element : elements )
			list.add( createNewBinddedDataFromModelClass( element ) );
		field.set( instance, list );
	}

	Object createNewBinddedDataFromModelClass( final Element element ) {
		final Object newInstance = modelClass.newInstanceOf();
		modelClass.bind( element, newInstance );
		return newInstance;
	}
}
