package stalkr.html;

import java.lang.reflect.Field;

import lombok.RequiredArgsConstructor;
import lombok.val;

import org.jsoup.nodes.Element;

@RequiredArgsConstructor
public class AttributeElementSetter implements Setter {

	final Field field;
	final String[] selectors;
	final String[] attributes;

	@Override
	public void bind( final Element document, final Object instance ) {
		try {
			for ( int i = 0; i < selectors.length; i++ ) {
				val element = document.select( selectors[i] ).first();
				if ( element != null ) {
					field.set( instance, element.attr( attributes[i] ) );
					return;
				}
			}
		} catch ( IllegalArgumentException | IllegalAccessException e ) {
			throw new RuntimeException( e );
		}
	}

}
