/*
 * Decompiled with CFR 0.152.
 */
package stalkr.html;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import stalkr.html.AttributeElementSetter;
import stalkr.html.BindableAttribute;
import stalkr.html.BindableClass;
import stalkr.html.BindableManyTimes;
import stalkr.html.BindableText;
import stalkr.html.RepeatableElementSetter;
import stalkr.html.Setter;
import stalkr.html.TextElementSetter;
import trip.spi.Singleton;

@Singleton
public class BindableClassFactory {
    final Map<Class<?>, BindableClass> cache = new ConcurrentHashMap();

    BindableClass createNewBindableClass(Class<?> clazz) {
        List<Setter> fields = this.stripBindableFieldsOfClazz(clazz);
        return new BindableClass(clazz, fields);
    }

    List<Setter> stripBindableFieldsOfClazz(Class<?> clazz) {
        ArrayList<Setter> list = new ArrayList<Setter>();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                this.memorizeBindableField(clazz, list, field);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    void memorizeBindableField(Class<?> clazz, List<Setter> list, Field field) {
        BindableManyTimes repeatableAnnotation;
        BindableAttribute attributeAnnotation;
        BindableText textAnnotation = field.getAnnotation(BindableText.class);
        if (textAnnotation != null) {
            list.add(this.memorizeBindableTextField(clazz, field, textAnnotation));
        }
        if ((attributeAnnotation = field.getAnnotation(BindableAttribute.class)) != null) {
            list.add(this.memorizeBindableAttributeField(clazz, field, attributeAnnotation));
        }
        if ((repeatableAnnotation = field.getAnnotation(BindableManyTimes.class)) != null) {
            list.add(this.memorizeRepeatableBinding(clazz, field, repeatableAnnotation));
        }
    }

    Setter memorizeBindableTextField(Class<?> clazz, Field field, BindableText annotation) {
        String selector = annotation.value();
        return new TextElementSetter(field, selector);
    }

    Setter memorizeBindableAttributeField(Class<?> clazz, Field field, BindableAttribute annotation) {
        String selector = annotation.selector();
        String attribute = annotation.attribute();
        return new AttributeElementSetter(field, selector, attribute);
    }

    Setter memorizeRepeatableBinding(Class<?> clazz, Field field, BindableManyTimes annotation) {
        String selector = annotation.selector();
        BindableClass bindableClass = this.getBindableClassFor(annotation.model());
        return new RepeatableElementSetter(selector, field, bindableClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BindableClass getBindableClassFor(Class<T> type) {
        BindableClass bindableData = this.cache.get(type);
        if (bindableData == null) {
            Map<Class<?>, BindableClass> map = this.cache;
            synchronized (map) {
                bindableData = this.cache.get(type);
                if (bindableData == null) {
                    bindableData = this.createNewBindableClass(type);
                    this.cache.put(type, bindableData);
                }
            }
        }
        return bindableData;
    }
}

