package kos.tests;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import kos.core.client.AutoGeneratedRestClient;
import kos.core.client.RestClientConfiguration;

/**
 * Auto generated rest client for {@link kos.tests.UserIpClient}.
 */
@javax.annotation.processing.Generated("kos.apt.rest.RestClientProcessor")
class UserIpClientAutoGeneratedRestClient extends AutoGeneratedRestClient implements kos.tests.UserIpClient {

    UserIpClientAutoGeneratedRestClient(RestClientConfiguration configuration) {
        super(configuration);
    }

    public io.vertx.core.Future<java.lang.Void> createUser(
        java.lang.Long hash,kos.tests.User user
    ) {
        final MultiMap headers = createEmptyHeaders()
            .add("X-Custom-Signature", configuration.getStringConverter().asString(hash))
        ;
        final String uri = "/users"
        ;

        return 
        send(
            HttpMethod.POST, uri, headers, user,
            java.lang.Void.class);
    }

    public io.vertx.core.Future<java.lang.Void> deleteUser(
        int id
    ) {
        final MultiMap headers = createEmptyHeaders()
        ;
        final String uri = "/users/:id"
            .replace(":id", configuration.getStringConverter().asString(id))
        ;

        return 
        execute(
            HttpMethod.DELETE, uri, headers, 
            java.lang.Void.class);
    }

    private static final TypeReference<java.util.Map<java.lang.String,java.lang.Object>> TYPE_REFERENCE_0 =
        new TypeReference<java.util.Map<java.lang.String,java.lang.Object>>() {};

    public io.vertx.core.Future<java.util.Map<java.lang.String,java.lang.Object>> retrieveUserAsMapById(
        int id
    ) {
        final MultiMap headers = createEmptyHeaders()
        ;
        final String uri = "/users/:id"
            .replace(":id", configuration.getStringConverter().asString(id))
        ;

        return 
        execute(
            HttpMethod.GET, uri, headers, 
            TYPE_REFERENCE_0);
    }

    public io.vertx.core.Future<kos.tests.User> retrieveUserById(
        int id
    ) {
        final MultiMap headers = createEmptyHeaders()
        ;
        final String uri = "/users/:id"
            .replace(":id", configuration.getStringConverter().asString(id))
        ;

        return 
        execute(
            HttpMethod.GET, uri, headers, 
            kos.tests.User.class);
    }

    private static final TypeReference<java.util.List<kos.tests.User>> TYPE_REFERENCE_1 =
        new TypeReference<java.util.List<kos.tests.User>>() {};

    public io.vertx.core.Future<java.util.List<kos.tests.User>> retrieveUsers(
        long timestamp
    ) {
        final MultiMap headers = createEmptyHeaders()
            .add("If-Modified-Since", configuration.getStringConverter().asString(timestamp))
        ;
        final String uri = "/users"
        ;

        return 
        execute(
            HttpMethod.GET, uri, headers, 
            TYPE_REFERENCE_1);
    }

    public io.vertx.core.Future<java.lang.Void> updateUser(
        int id,long hash,kos.tests.User user
    ) {
        final MultiMap headers = createEmptyHeaders()
            .add("X-Custom-Signature", configuration.getStringConverter().asString(hash))
        ;
        final String uri = "/users/:id"
            .replace(":id", configuration.getStringConverter().asString(id))
        ;

        return 
        send(
            HttpMethod.PUT, uri, headers, user,
            java.lang.Void.class);
    }

    public io.vertx.core.Future<java.lang.Void> updateUser(
        int id,kos.tests.User user
    ) {
        final MultiMap headers = createEmptyHeaders()
        ;
        final String uri = "/users/:id"
            .replace(":id", configuration.getStringConverter().asString(id))
        ;

        return 
        send(
            HttpMethod.PATCH, uri, headers, user,
            java.lang.Void.class);
    }


}
