package kos.tests;

import kos.api.*;
import kos.core.*;
import kos.core.validation.*;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.RoutingContext;

/**
 * Auto generated server configuration for {@link kos.tests.ApiWithAllAnnotations}.
 */
@SuppressWarnings("all")
@injector.Singleton
@javax.annotation.processing.Generated("kos.apt.rest.RestApiProcessor")
public class ApiWithAllAnnotationsRoutingContextHandler implements WebServerEventListener {

    public int priority() {
        return Integer.MIN_VALUE;
    }

    /**
     * Response Handler for PATCH requests received by {@link ApiWithAllAnnotations.amendMySystem}.
     */
    private static class ResponseTypeHandlerFor$AmendMySystem$7b6c32882eb892ed7eacd95f2441bed9f4deb3562c98b0f2fd29458b365d930e implements Handler<AsyncResult<kos.api.Response>> {

        private final KosContext kosContext;
        private final RoutingContext routingContext;

        ResponseTypeHandlerFor$AmendMySystem$7b6c32882eb892ed7eacd95f2441bed9f4deb3562c98b0f2fd29458b365d930e(KosContext kosContext, RoutingContext routingContext) {
            this.routingContext = routingContext;
            this.kosContext = kosContext;
        }

        public void handle( AsyncResult<kos.api.Response> as ) {
            if (as.succeeded())
                Response.send(kosContext, routingContext, as.result());
            else
                Response.sendError(kosContext, routingContext, as.cause());
        }
    }

    /**
     * Response Handler for DELETE requests received by {@link ApiWithAllAnnotations.deleteData}.
     */
    private static class ResponseTypeHandlerFor$DeleteData$360da4cf756ab79deb4806c807b844b9c707977f5b6184a2f1650f8dedb74aff implements Handler<AsyncResult<kos.api.Response>> {

        private final KosContext kosContext;
        private final RoutingContext routingContext;

        ResponseTypeHandlerFor$DeleteData$360da4cf756ab79deb4806c807b844b9c707977f5b6184a2f1650f8dedb74aff(KosContext kosContext, RoutingContext routingContext) {
            this.routingContext = routingContext;
            this.kosContext = kosContext;
        }

        public void handle( AsyncResult<kos.api.Response> as ) {
            if (as.succeeded())
                Response.send(kosContext, routingContext, as.result());
            else
                Response.sendError(kosContext, routingContext, as.cause());
        }
    }

    /**
     * Response Handler for GET requests received by {@link ApiWithAllAnnotations.doSomethingElse}.
     */
    private static class ResponseTypeHandlerFor$DoSomethingElse$7f73751ad367a44a011ab732b5b0d562918550a0d180209310e6ece4c5b8186c implements Handler<AsyncResult<kos.api.Response>> {

        private final KosContext kosContext;
        private final RoutingContext routingContext;

        ResponseTypeHandlerFor$DoSomethingElse$7f73751ad367a44a011ab732b5b0d562918550a0d180209310e6ece4c5b8186c(KosContext kosContext, RoutingContext routingContext) {
            this.routingContext = routingContext;
            this.kosContext = kosContext;
        }

        public void handle( AsyncResult<kos.api.Response> as ) {
            if (as.succeeded())
                Response.send(kosContext, routingContext, as.result());
            else
                Response.sendError(kosContext, routingContext, as.cause());
        }
    }


    public void on(WebServerEventListener.BeforeDeployWebServerEvent event) {
        final KosContext kosContext = event.getKosContext();
        final ImplementationLoader implementationLoader = kosContext.getImplementationLoader();
        final VertxFutures futures = implementationLoader.instanceOfOrFail(VertxFutures.class);
        final WebPointcutValidation webPointcutValidation = implementationLoader.instanceOfOrFail(WebPointcutValidation.class);

        // Fetches an instance of the web handler class
        final ApiWithAllAnnotations handler = implementationLoader.instanceOfOrFail(ApiWithAllAnnotations.class);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#amendMySystem}.
         */
        Handler<RoutingContext> handlerForAmendMySystem$7b6c32882eb892ed7eacd95f2441bed9f4deb3562c98b0f2fd29458b365d930e = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                    final io.vertx.core.Future<kos.api.Response> response =
                        handler.amendMySystem(
                        );
                    /* Wraps response as Future */
                    futures.asFuture(response).onComplete(new ResponseTypeHandlerFor$AmendMySystem$7b6c32882eb892ed7eacd95f2441bed9f4deb3562c98b0f2fd29458b365d930e(kosContext, routingContext));
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.PATCH, "/api/customer/:customerId", handlerForAmendMySystem$7b6c32882eb892ed7eacd95f2441bed9f4deb3562c98b0f2fd29458b365d930e);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#deleteData}.
         */
        Handler<RoutingContext> handlerForDeleteData$360da4cf756ab79deb4806c807b844b9c707977f5b6184a2f1650f8dedb74aff = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                    final java.util.concurrent.CompletableFuture<kos.api.Response> response =
                        handler.deleteData(
                            /* Read Context parameter identified by "somethingElse" */
                            Request.readContext( kosContext, routingContext, "somethingElse", kos.tests.SomethingElse.class )
                        );
                    /* Wraps response as Future */
                    futures.asFuture(response).onComplete(new ResponseTypeHandlerFor$DeleteData$360da4cf756ab79deb4806c807b844b9c707977f5b6184a2f1650f8dedb74aff(kosContext, routingContext));
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.DELETE, "/api/customer/:customerId", handlerForDeleteData$360da4cf756ab79deb4806c807b844b9c707977f5b6184a2f1650f8dedb74aff);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#doNothing}.
         */
        Handler<RoutingContext> handlerForDoNothing$926b11b42b1186f672e2f140f5bf78d3ed6d4cb8657bc0a68ae15c69905117ba = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                        handler.doNothing(
                        );
                    /* Sends the default response for "no content". */
                    Response.sendDefaultNoContent( kosContext, routingContext );
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.GET, "/api/customer/:customerId", handlerForDoNothing$926b11b42b1186f672e2f140f5bf78d3ed6d4cb8657bc0a68ae15c69905117ba);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#doSomethingElse}.
         */
        Handler<RoutingContext> handlerForDoSomethingElse$7f73751ad367a44a011ab732b5b0d562918550a0d180209310e6ece4c5b8186c = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                    final kos.api.Response response =
                        handler.doSomethingElse(
                            /* Read Param parameter identified by "q" */
                            Request.readParam( kosContext, routingContext, "q", java.lang.String.class )
                        );
                    /* Wraps response as Future */
                    futures.asFuture(response).onComplete(new ResponseTypeHandlerFor$DoSomethingElse$7f73751ad367a44a011ab732b5b0d562918550a0d180209310e6ece4c5b8186c(kosContext, routingContext));
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.GET, "/api/customer/:customerId/search", handlerForDoSomethingElse$7f73751ad367a44a011ab732b5b0d562918550a0d180209310e6ece4c5b8186c);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#persistSomething}.
         */
        Handler<RoutingContext> handlerForPersistSomething$b619d14f5cb8ddf4d093afcff02443a06d235f226d367ec3d14d0e6ac3a2614d = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                        handler.persistSomething(
                            /* Read Header parameter identified by "X-Secure-Creds" */
                            Request.readHeader( kosContext, routingContext, "X-Secure-Creds", java.lang.String.class ),
                            /* Read attached (and pre-validated) Body parameter identified by "something" */
                            webPointcutValidation.unwrapForBody(routingContext, "something")
                        );
                    /* Sends the default response for "no content". */
                    Response.sendDefaultNoContent( kosContext, routingContext );
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };

        // Validates the parameter identified as something
        handlerForPersistSomething$b619d14f5cb8ddf4d093afcff02443a06d235f226d367ec3d14d0e6ac3a2614d = webPointcutValidation.wrapForBody( kos.tests.Something.class, "something", handlerForPersistSomething$b619d14f5cb8ddf4d093afcff02443a06d235f226d367ec3d14d0e6ac3a2614d );
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.POST, "/api/customer/:customerId", handlerForPersistSomething$b619d14f5cb8ddf4d093afcff02443a06d235f226d367ec3d14d0e6ac3a2614d);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#updateSomething}.
         */
        Handler<RoutingContext> handlerForUpdateSomething$3ae80432eb49979bc5a8cf6eba2b5b8e96b8b6eeaad7b95ccb7f53b2cbb15b15 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                        handler.updateSomething(
                            /* Read Param parameter identified by "q" */
                            Request.readParam( kosContext, routingContext, "q", java.lang.String.class ),
                            /* Read attached (and pre-validated) Body parameter identified by "something" */
                            webPointcutValidation.unwrapForBody(routingContext, "something")
                        );
                    /* Sends the default response for "no content". */
                    Response.sendDefaultNoContent( kosContext, routingContext );
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };

        // Validates the parameter identified as something
        handlerForUpdateSomething$3ae80432eb49979bc5a8cf6eba2b5b8e96b8b6eeaad7b95ccb7f53b2cbb15b15 = webPointcutValidation.wrapForBody( kos.tests.Something.class, "something", handlerForUpdateSomething$3ae80432eb49979bc5a8cf6eba2b5b8e96b8b6eeaad7b95ccb7f53b2cbb15b15 );
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.PUT, "/api/customer/:customerId/:id", handlerForUpdateSomething$3ae80432eb49979bc5a8cf6eba2b5b8e96b8b6eeaad7b95ccb7f53b2cbb15b15);

    }

}
