package kos.tests;

import kos.api.*;
import kos.core.*;
import kos.core.validation.*;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.RoutingContext;

/**
 * Auto generated server configuration for {@link kos.tests.ApiWithAllAnnotations}.
 */
@SuppressWarnings("all")
@injector.Singleton
@javax.annotation.processing.Generated("kos.apt.rest.RestApiProcessor")
public class ApiWithAllAnnotationsRoutingContextHandler implements WebServerEventListener {

    public int priority() {
        return Integer.MIN_VALUE;
    }

    /**
     * Response Handler for PATCH requests received by {@link ApiWithAllAnnotations.amendMySystem}.
     */
    private static class ResponseTypeHandlerFor$AmendMySystem$PATCH633940147 implements Handler<AsyncResult<kos.api.Response>> {

        private final KosContext kosContext;
        private final RoutingContext routingContext;

        ResponseTypeHandlerFor$AmendMySystem$PATCH633940147(KosContext kosContext, RoutingContext routingContext) {
            this.routingContext = routingContext;
            this.kosContext = kosContext;
        }

        public void handle( AsyncResult<kos.api.Response> as ) {
            if (as.succeeded())
                Response.send(kosContext, routingContext, as.result());
            else
                Response.sendError(kosContext, routingContext, as.cause());
        }
    }

    /**
     * Response Handler for DELETE requests received by {@link ApiWithAllAnnotations.deleteData}.
     */
    private static class ResponseTypeHandlerFor$DeleteData$DELETE1620623714 implements Handler<AsyncResult<kos.api.Response>> {

        private final KosContext kosContext;
        private final RoutingContext routingContext;

        ResponseTypeHandlerFor$DeleteData$DELETE1620623714(KosContext kosContext, RoutingContext routingContext) {
            this.routingContext = routingContext;
            this.kosContext = kosContext;
        }

        public void handle( AsyncResult<kos.api.Response> as ) {
            if (as.succeeded())
                Response.send(kosContext, routingContext, as.result());
            else
                Response.sendError(kosContext, routingContext, as.cause());
        }
    }

    /**
     * Response Handler for GET requests received by {@link ApiWithAllAnnotations.doSomethingElse}.
     */
    private static class ResponseTypeHandlerFor$DoSomethingElse$GET1751774120 implements Handler<AsyncResult<kos.api.Response>> {

        private final KosContext kosContext;
        private final RoutingContext routingContext;

        ResponseTypeHandlerFor$DoSomethingElse$GET1751774120(KosContext kosContext, RoutingContext routingContext) {
            this.routingContext = routingContext;
            this.kosContext = kosContext;
        }

        public void handle( AsyncResult<kos.api.Response> as ) {
            if (as.succeeded())
                Response.send(kosContext, routingContext, as.result());
            else
                Response.sendError(kosContext, routingContext, as.cause());
        }
    }


    public void on(WebServerEventListener.BeforeDeployWebServerEvent event) {
        final KosContext kosContext = event.getKosContext();
        final ImplementationLoader implementationLoader = kosContext.getImplementationLoader();
        final VertxFutures futures = implementationLoader.instanceOfOrFail(VertxFutures.class);
        final WebPointcutValidation webPointcutValidation = implementationLoader.instanceOfOrFail(WebPointcutValidation.class);

        // Fetches an instance of the web handler class
        final ApiWithAllAnnotations handler = implementationLoader.instanceOfOrFail(ApiWithAllAnnotations.class);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#amendMySystem}.
         */
        Handler<RoutingContext> handlerForAmendMySystem$PATCH633940147 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                    final io.vertx.core.Future<kos.api.Response> response =
                        handler.amendMySystem(
                        );
                    /* Wraps response as Future */
                    futures.asFuture(response).onComplete(new ResponseTypeHandlerFor$AmendMySystem$PATCH633940147(kosContext, routingContext));
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.PATCH, "/api/customer/:customerId", handlerForAmendMySystem$PATCH633940147);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#deleteData}.
         */
        Handler<RoutingContext> handlerForDeleteData$DELETE1620623714 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                    final java.util.concurrent.CompletableFuture<kos.api.Response> response =
                        handler.deleteData(
                            /* Read Context parameter identified by "somethingElse" */
                            Request.readContext( kosContext, routingContext, "somethingElse", kos.tests.SomethingElse.class )
                        );
                    /* Wraps response as Future */
                    futures.asFuture(response).onComplete(new ResponseTypeHandlerFor$DeleteData$DELETE1620623714(kosContext, routingContext));
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.DELETE, "/api/customer/:customerId", handlerForDeleteData$DELETE1620623714);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#doNothing}.
         */
        Handler<RoutingContext> handlerForDoNothing$GET265973530 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                        handler.doNothing(
                        );
                    /* Sends the default response for "no content". */
                    Response.sendDefaultNoContent( kosContext, routingContext );
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.GET, "/api/customer/:customerId", handlerForDoNothing$GET265973530);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#doSomethingElse}.
         */
        Handler<RoutingContext> handlerForDoSomethingElse$GET1751774120 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                    final kos.api.Response response =
                        handler.doSomethingElse(
                            /* Read Param parameter identified by "q" */
                            Request.readParam( kosContext, routingContext, "q", java.lang.String.class )
                        );
                    /* Wraps response as Future */
                    futures.asFuture(response).onComplete(new ResponseTypeHandlerFor$DoSomethingElse$GET1751774120(kosContext, routingContext));
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.GET, "/api/customer/:customerId/search", handlerForDoSomethingElse$GET1751774120);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#persistSomething}.
         */
        Handler<RoutingContext> handlerForPersistSomething$POST344466364 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                        handler.persistSomething(
                            /* Read Header parameter identified by "X-Secure-Creds" */
                            Request.readHeader( kosContext, routingContext, "X-Secure-Creds", java.lang.String.class ),
                            /* Read attached (and pre-validated) Body parameter identified by "something" */
                            webPointcutValidation.unwrapForBody(routingContext, "something")
                        );
                    /* Sends the default response for "no content". */
                    Response.sendDefaultNoContent( kosContext, routingContext );
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };

        // Validates the parameter identified as something
        handlerForPersistSomething$POST344466364 = webPointcutValidation.wrapForBody( kos.tests.Something.class, "something", handlerForPersistSomething$POST344466364 );
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.POST, "/api/customer/:customerId", handlerForPersistSomething$POST344466364);

        /**
         * Handle incoming requests mapped for {@link kos.tests.ApiWithAllAnnotations#updateSomething}.
         */
        Handler<RoutingContext> handlerForUpdateSomething$PUT1716747768 = new Handler<RoutingContext>() {

            public void handle(final RoutingContext routingContext) {
                try {
                    /* Call original handler */
                        handler.updateSomething(
                            /* Read Param parameter identified by "q" */
                            Request.readParam( kosContext, routingContext, "q", java.lang.String.class ),
                            /* Read attached (and pre-validated) Body parameter identified by "something" */
                            webPointcutValidation.unwrapForBody(routingContext, "something")
                        );
                    /* Sends the default response for "no content". */
                    Response.sendDefaultNoContent( kosContext, routingContext );
                } catch (Throwable cause){
                    Response.sendError(kosContext, routingContext, cause);
                }
            }
        };

        // Validates the parameter identified as something
        handlerForUpdateSomething$PUT1716747768 = webPointcutValidation.wrapForBody( kos.tests.Something.class, "something", handlerForUpdateSomething$PUT1716747768 );
        // Maps the method handler to an HTTP endpoint
        event.getRouter().route( HttpMethod.PUT, "/api/customer/:customerId/:id", handlerForUpdateSomething$PUT1716747768);

    }

}
