/*
 * Decompiled with CFR 0.152.
 */
package kos.config;

import io.vertx.config.ConfigChange;
import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import java.util.function.Function;
import kos.api.KosContext;

class YamlConfigRetriever
implements ConfigRetriever {
    private final KosContext kosContext;
    private ConfigRetriever delegated;

    public ConfigRetriever getConfigRetriever() {
        if (this.delegated == null) {
            this.delegated = this.createConfigRetriever();
        }
        return this.delegated;
    }

    private ConfigRetriever createConfigRetriever() {
        ConfigRetrieverOptions configRetrieverOptions = new ConfigRetrieverOptions();
        configRetrieverOptions.addStore(this.createStoreForProduction());
        configRetrieverOptions.addStore(this.createStoreForTest());
        return ConfigRetriever.create((Vertx)this.kosContext.getDefaultVertx(), (ConfigRetrieverOptions)configRetrieverOptions);
    }

    ConfigStoreOptions createStoreForProduction() {
        return new ConfigStoreOptions().setOptional(true).setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", (Object)"conf/application.yml"));
    }

    ConfigStoreOptions createStoreForTest() {
        return new ConfigStoreOptions().setOptional(true).setType("file").setFormat("yaml").setConfig(new JsonObject().put("path", (Object)"conf/application-test.yml"));
    }

    public YamlConfigRetriever(KosContext kosContext) {
        this.kosContext = kosContext;
    }

    public void getConfig(Handler<AsyncResult<JsonObject>> handler) {
        this.getConfigRetriever().getConfig(handler);
    }

    public Future<JsonObject> getConfig() {
        return this.getConfigRetriever().getConfig();
    }

    public void close() {
        this.getConfigRetriever().close();
    }

    public JsonObject getCachedConfig() {
        return this.getConfigRetriever().getCachedConfig();
    }

    public void listen(Handler<ConfigChange> handler) {
        this.getConfigRetriever().listen(handler);
    }

    public ConfigRetriever setBeforeScanHandler(Handler<Void> handler) {
        return this.getConfigRetriever().setBeforeScanHandler(handler);
    }

    public ConfigRetriever setConfigurationProcessor(Function<JsonObject, JsonObject> function) {
        return this.getConfigRetriever().setConfigurationProcessor(function);
    }

    public ReadStream<JsonObject> configStream() {
        return this.getConfigRetriever().configStream();
    }
}

