/*
 * Decompiled with CFR 0.152.
 */
package injector.sample;

import injector.ExposedAs;
import injector.Job;
import injector.sample.ClientBImpl;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@ExposedAs(value=Job.class)
public class ClientBImplMainloopRunner0
implements Job {
    private static final ExecutorService BACKGROUND = Executors.newFixedThreadPool(1);
    private static boolean JOB_MAY_RUN = true;
    private final ClientBImpl instance;

    public ClientBImplMainloopRunner0(ClientBImpl clientBImpl) {
        this.instance = clientBImpl;
    }

    @Override
    public void execute() throws Exception {
        for (int i = 0; i < 1; ++i) {
            BACKGROUND.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (JOB_MAY_RUN) {
                            ClientBImplMainloopRunner0.this.instance.runMultipleTimes();
                            Thread.sleep(1L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable throwable) {
                        System.err.println("Failed to execute ClientBImpl.runMultipleTimes in background. Aborted.");
                        throwable.printStackTrace();
                    }
                }
            });
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    JOB_MAY_RUN = false;
                    BACKGROUND.shutdown();
                    if (!BACKGROUND.awaitTermination(120L, TimeUnit.SECONDS)) {
                        List<Runnable> list = BACKGROUND.shutdownNow();
                        System.err.println("Executor was abruptly shut down. " + list.size() + " tasks will not be executed.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }
}

