/*
 * Decompiled with CFR 0.152.
 */
package injector;

import injector.ExposedServicesLoader;
import injector.Injector;
import java.util.Iterator;

public class LazyExposedServiceLoader<T>
implements Iterable<T> {
    private ExposedServicesLoader<T> original;
    private Injector injector;
    private Iterable<T> loaded;

    public LazyExposedServiceLoader(ExposedServicesLoader<T> exposedServicesLoader, Injector injector) {
        this.original = exposedServicesLoader;
        this.injector = injector;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getLoaded().iterator();
    }

    private Iterable<T> getLoaded() {
        if (this.loaded == null) {
            this.loaded = this.loadLoaderFromInjector();
        }
        return this.loaded;
    }

    private Iterable<T> loadLoaderFromInjector() {
        try {
            Iterable<T> iterable = this.original.load(this.injector);
            return iterable;
        }
        finally {
            this.injector = null;
            this.original = null;
        }
    }
}

